/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.HostPort;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.LogWriter;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPMessageStack;
import gov.nist.javax.sip.stack.TCPMessageChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

public class TCPMessageProcessor
extends MessageProcessor {
    protected Thread thread;
    protected int port;
    protected int nConnections;
    private boolean isRunning;
    private Hashtable tcpMessageChannels;
    private ServerSocket sock;
    protected int useCount;
    protected SIPMessageStack sipStack;

    protected TCPMessageProcessor(SIPMessageStack sIPMessageStack, int n) {
        this.sipStack = sIPMessageStack;
        this.port = n;
        this.tcpMessageChannels = new Hashtable();
    }

    public void start() throws IOException {
        this.thread = new Thread(this);
        this.thread.setName("TCPMessageProcessorThread");
        this.thread.setDaemon(true);
        this.sock = this.sipStack.getNetworkLayer().createServerSocket(this.port, 0, this.sipStack.savedStackInetAddress);
        this.isRunning = true;
        this.thread.start();
    }

    public Thread getThread() {
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.isRunning) {
            try {
                Object object = this;
                synchronized (object) {
                    while (this.isRunning && this.sipStack.maxConnections != -1 && this.nConnections >= this.sipStack.maxConnections) {
                        try {
                            this.wait();
                            if (this.isRunning) continue;
                            return;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                            break;
                        }
                    }
                    ++this.nConnections;
                }
                object = this.sock.accept();
                if (LogWriter.needsLogging) {
                    this.getSIPStack().logWriter.logMessage("Accepting new connection!");
                }
                TCPMessageChannel tCPMessageChannel = new TCPMessageChannel((Socket)object, this.sipStack, this);
            }
            catch (SocketException socketException) {
                this.isRunning = false;
            }
            catch (IOException iOException) {
                if (!LogWriter.needsLogging) continue;
                this.getSIPStack().logWriter.logException(iOException);
            }
            catch (Exception exception) {
                InternalErrorHandler.handleException(exception);
            }
        }
    }

    public String getTransport() {
        return "tcp";
    }

    public int getPort() {
        return this.port;
    }

    public SIPMessageStack getSIPStack() {
        return this.sipStack;
    }

    public synchronized void stop() {
        this.isRunning = false;
        this.listeningPoint = null;
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Collection collection = this.tcpMessageChannels.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            TCPMessageChannel tCPMessageChannel = (TCPMessageChannel)iterator.next();
            tCPMessageChannel.close();
        }
        this.notify();
    }

    protected synchronized void remove(TCPMessageChannel tCPMessageChannel) {
        String string = tCPMessageChannel.getKey();
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage(Thread.currentThread() + " removing " + string);
        }
        if (this.tcpMessageChannels.get(string) == tCPMessageChannel) {
            this.tcpMessageChannels.remove(string);
        }
    }

    public synchronized MessageChannel createMessageChannel(HostPort hostPort) throws IOException {
        String string = MessageChannel.getKey(hostPort, "TCP");
        if (this.tcpMessageChannels.get(string) != null) {
            return (TCPMessageChannel)this.tcpMessageChannels.get(string);
        }
        TCPMessageChannel tCPMessageChannel = new TCPMessageChannel(hostPort.getInetAddress(), hostPort.getPort(), this.sipStack, this);
        this.tcpMessageChannels.put(string, tCPMessageChannel);
        tCPMessageChannel.isCached = true;
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("key " + string);
            this.sipStack.logWriter.logMessage("Creating " + tCPMessageChannel);
        }
        return tCPMessageChannel;
    }

    protected synchronized void cacheMessageChannel(TCPMessageChannel tCPMessageChannel) {
        String string = tCPMessageChannel.getKey();
        TCPMessageChannel tCPMessageChannel2 = (TCPMessageChannel)this.tcpMessageChannels.get(string);
        if (tCPMessageChannel2 != null) {
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("Closing " + string);
            }
            tCPMessageChannel2.close();
        }
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("Caching " + string);
        }
        this.tcpMessageChannels.put(string, tCPMessageChannel);
    }

    public synchronized MessageChannel createMessageChannel(InetAddress inetAddress, int n) throws IOException {
        try {
            String string = MessageChannel.getKey(inetAddress, n, "TCP");
            if (this.tcpMessageChannels.get(string) != null) {
                return (TCPMessageChannel)this.tcpMessageChannels.get(string);
            }
            TCPMessageChannel tCPMessageChannel = new TCPMessageChannel(inetAddress, n, this.sipStack, this);
            this.tcpMessageChannels.put(string, tCPMessageChannel);
            tCPMessageChannel.isCached = true;
            if (LogWriter.needsLogging) {
                this.sipStack.logMessage("key " + string);
                this.sipStack.logMessage("Creating " + tCPMessageChannel);
            }
            return tCPMessageChannel;
        }
        catch (UnknownHostException unknownHostException) {
            throw new IOException(unknownHostException.getMessage());
        }
    }

    public int getMaximumMessageSize() {
        return Integer.MAX_VALUE;
    }

    public String getNAPTRService() {
        return "SIP+D2T";
    }

    public String getSRVPrefix() {
        return "_sip._tcp.";
    }

    public boolean inUse() {
        return this.useCount != 0;
    }

    public int getDefaultTargetPort() {
        return 5060;
    }

    public boolean isSecure() {
        return false;
    }
}

