/*
 * Decompiled with CFR 0.152.
 */
package hr.fer.tel.nims.dsa.server;

import hr.fer.tel.nims.dsa.server.ConfigurationHandler;
import hr.fer.tel.nims.dsa.server.SignalingEventListener;
import hr.fer.tel.nims.dsa.server.sipagent.SIPUserAgent;
import hr.fer.tel.nims.dsa.server.sipagent.SIPUserAgentServer;
import hr.fer.tel.nims.dsa.server.sipinterface.SipInterface;
import java.io.IOException;
import javax.sip.InvalidArgumentException;
import javax.sip.SipException;

public class SignalingManager {
    private ConfigurationHandler configurationHandler;
    private SIPUserAgent sipUserAgent;
    private SIPUserAgentServer sipUserAgentServer;
    private SipInterfaceImpl sipInterfaceImpl;

    public SignalingManager(String configurationFile) {
        this.configurationHandler = new ConfigurationHandler(configurationFile);
        this.sipInterfaceImpl = new SipInterfaceImpl(null);
    }

    public SignalingManager(String configurationFile, SignalingEventListener signalingEventListener) {
        this.configurationHandler = new ConfigurationHandler(configurationFile);
        this.sipInterfaceImpl = new SipInterfaceImpl(signalingEventListener);
    }

    public void startSignalingManager() {
        try {
            this.configurationHandler.init();
        }
        catch (IOException ioe) {
            System.out.println("Could not find or read from the configuration file!\nError reading the configuration!");
            System.exit(-1);
        }
        catch (IllegalArgumentException iae) {
            System.out.println(String.valueOf(iae.getMessage()) + "\nInvalid configuration argument!");
            System.exit(-1);
        }
        this.sipUserAgentServer = new SIPUserAgentServer(this.sipInterfaceImpl);
        this.sipUserAgent = new SIPUserAgent(this.sipUserAgentServer, this.configurationHandler, true);
        this.sipUserAgentServer.setSipUserAgent(this.sipUserAgent);
        try {
            this.sipUserAgent.start();
        }
        catch (SipException se) {
            System.out.println(se.getMessage());
            System.exit(-1);
        }
        catch (InvalidArgumentException iae) {
            System.out.println(String.valueOf(iae.getMessage()) + "\nThe specified transport port already taken by another application!");
            System.exit(-1);
        }
        System.out.println("\nSignaling manager successfully started...\n");
    }

    public void changeInServiceRequirements(String clientIpAddress, String newServiceConfiguration) {
        this.sipUserAgentServer.updateSipSession(clientIpAddress, newServiceConfiguration);
    }

    public void shutDownSignalingManager() {
        try {
            this.sipUserAgent.stop();
        }
        catch (Exception e) {
            System.out.println("\nUnable to stop the signaling manager!\n");
        }
    }

    private class SipInterfaceImpl
    implements SipInterface {
        private SignalingEventListener signalingEventListener;

        SipInterfaceImpl(SignalingEventListener sel) {
            this.signalingEventListener = sel;
        }

        public void handleSipSessionEstablishmentFailedEvent(String message, String remoteClient) {
            this.signalingEventListener.handleSessionEstablishmentFailedEvent("\nSorry, you have failed to establish session, try again!\n", remoteClient);
        }

        public void handleSipSessionEstablishedEvent(String finalServiceProfile, String remoteClient) {
            this.signalingEventListener.handleSessionEstablishedEvent(finalServiceProfile, remoteClient);
        }

        public void handleNetworkResourcesReleasedEvent(String remoteClient) {
            this.signalingEventListener.handleNetworkResourcesReleasedEvent(remoteClient);
        }

        public void handleSipSessionUpdateFailedEvent(String message, String remoteClient) {
            this.signalingEventListener.handleSessionUpdateFailedEvent("\nSorry, you have failed to update session, try again!\n", remoteClient);
        }

        public void handleFinalServiceProfileChangedEvent(String newFinalServiceProfile, String message, String remoteClient) {
            System.out.println(message);
            this.signalingEventListener.handleSessionUpdatedEvent(newFinalServiceProfile, remoteClient);
        }

        public void handleSipSessionTerminatedEvent(String remoteClient) {
            this.signalingEventListener.handleSessionTerminatedEvent(remoteClient);
        }
    }
}

