/*
 * Decompiled with CFR 0.152.
 */
package hr.fer.tel.nims.dsa.server.profilehandling;

import hr.fer.tel.nims.dsa.server.profilehandling.SdpFileReader;
import hr.fer.tel.nims.dsa.server.profilehandling.XmlFilenameFilter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ProfileManager {
    String serviceProfiles = "";
    private String serviceRepository = "serviceprofilerepository";
    private String sdpMediaDescription = "sdpmediadescription\\sdpParameters.txt";

    public String getServiceProfiles(String service) throws NullPointerException, FileNotFoundException, IOException, SAXException {
        if (service.indexOf(".") != -1) {
            service = service.substring(0, service.indexOf("."));
        }
        this.serviceRepository = String.valueOf(this.serviceRepository) + "\\" + service + "\\" + "profiles";
        SdpFileReader sdpFile = new SdpFileReader(this.sdpMediaDescription);
        try {
            this.serviceProfiles = sdpFile.getFileText();
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            return null;
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            return null;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        this.serviceProfiles = String.valueOf(this.serviceProfiles) + "\n";
        File[] files = new File(this.serviceRepository).listFiles(new XmlFilenameFilter());
        if (files == null) {
            throw new FileNotFoundException();
        }
        int i = 0;
        while (i < files.length) {
            this.serviceProfiles = String.valueOf(this.serviceProfiles) + new SdpFileReader(files[i]).getFileText();
            this.serviceProfiles = String.valueOf(this.serviceProfiles) + "\n";
            ++i;
        }
        return this.serviceProfiles;
    }

    public Document getDocumentFromString(String string) throws IOException, SAXException {
        Document document = null;
        StringReader stringReader = new StringReader(string);
        String header = new String();
        boolean foundHeader = false;
        stringReader.mark(1);
        int charRead = stringReader.read();
        while (!foundHeader && charRead != -1) {
            if (charRead == 60) {
                charRead = stringReader.read();
                while (charRead != -1 && charRead != 62) {
                    header = String.valueOf(header) + String.valueOf((char)charRead);
                    charRead = stringReader.read();
                }
                if (charRead == 62 && header.contains("?xml version=\"1.0\"")) {
                    foundHeader = true;
                    System.out.println("Nasao sam header");
                }
            }
            if (!foundHeader) {
                stringReader.mark(1);
            }
            charRead = stringReader.read();
        }
        if (foundHeader) {
            stringReader.reset();
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(stringReader));
            document = parser.getDocument();
        }
        try {
            stringReader.close();
        }
        catch (NullPointerException npe) {
            System.out.println("There was a problem closing a stream.\n\tContinuing...\n");
        }
        return document;
    }

    public String getStringFromDocument(Document document) {
        try {
            DOMSource domSource = new DOMSource(document);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
            System.out.println("\nUnable to convert a Document object to a String object!\n");
            return null;
        }
    }
}

