/*
 * Decompiled with CFR 0.152.
 */
package hr.fer.tel.nims.dsa.server.sipagent;

import hr.fer.tel.nims.dsa.server.sipagent.SessionData;
import java.util.Hashtable;
import java.util.Map;

public class SessionMapping {
    private Map sessionData = new Hashtable();
    private Map keyMapping = new Hashtable();

    public void addSessionData(SessionData sessionData) {
        String sessionId = new String(sessionData.getCallId());
        this.sessionData.put(sessionId, sessionData);
        String ipAddress = new String(sessionData.getRemoteHost());
        this.keyMapping.put(ipAddress, sessionId);
    }

    public boolean containsSessionData(String sessionId) {
        boolean contains = false;
        if (this.sessionData.containsKey(sessionId)) {
            contains = true;
        }
        return contains;
    }

    public SessionData getSessionData(String sessionId) {
        return (SessionData)this.sessionData.get(sessionId);
    }

    public String getKey(String ipAddress) {
        return (String)this.keyMapping.get(ipAddress);
    }

    public void removeSessionData(String sessionId) {
        SessionData sessionData = this.getSessionData(sessionId);
        if (sessionData == null) {
            System.out.println("\nRemoval of session data with the ID: " + sessionId + "\nfrom the mapping is unsuccessful!" + "\nSession data does not exist or has already been erased!");
            return;
        }
        String ipAddress = new String(sessionData.getRemoteHost());
        this.keyMapping.remove(ipAddress);
        this.sessionData.remove(sessionId);
        sessionData = null;
    }

    public void clearAll() {
        this.keyMapping.clear();
        this.sessionData.clear();
    }

    public boolean isEmpty() {
        return this.sessionData.isEmpty();
    }
}

