/*
 * Decompiled with CFR 0.152.
 */
package javax.sip;

import java.io.ObjectStreamException;
import java.io.Serializable;

public final class DialogState
implements Serializable {
    private int m_dialogState;
    private static int m_size = 4;
    private static DialogState[] m_dialogStateArray = new DialogState[m_size];
    public static final int _EARLY = 0;
    public static final DialogState EARLY = new DialogState(0);
    public static final int _CONFIRMED = 1;
    public static final DialogState CONFIRMED = new DialogState(1);
    public static final int _COMPLETED = 2;
    public static final DialogState COMPLETED = new DialogState(2);
    public static final int _TERMINATED = 3;
    public static final DialogState TERMINATED = new DialogState(3);

    private DialogState(int n) {
        this.m_dialogState = n;
        DialogState.m_dialogStateArray[this.m_dialogState] = this;
    }

    public static DialogState getObject(int n) {
        if (n >= 0 && n < m_size) {
            return m_dialogStateArray[n];
        }
        throw new IllegalArgumentException("Invalid dialogState value");
    }

    public int getValue() {
        return this.m_dialogState;
    }

    private Object readResolve() throws ObjectStreamException {
        return m_dialogStateArray[this.m_dialogState];
    }

    public String toString() {
        String string = "";
        switch (this.m_dialogState) {
            case 0: {
                string = "Early Dialog";
                break;
            }
            case 1: {
                string = "Confirmed Dialog";
                break;
            }
            case 2: {
                string = "Completed Dialog";
                break;
            }
            case 3: {
                string = "Terminated Dialog";
                break;
            }
            default: {
                string = "Error while printing Dialog State";
            }
        }
        return string;
    }
}

