/*
 * Decompiled with CFR 0.152.
 */
package hr.fer.teletk.sipas.matching;

import hr.fer.teletk.sipas.proxy.ProxyOutput;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Vector;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SipAsQnc {
    private Document clientProfile;
    private Document[] serviceProfiles;
    private ProxyOutput proxyOutput;

    public void setNewClientProfile(String inviteContent) {
        try {
            this.clientProfile = this.getClientProfileFromContent(inviteContent);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.proxyOutput != null) {
                this.proxyOutput.showError("Error while trying to create service and clientprofiles!...Matching stopped!");
            }
            return;
        }
    }

    public SipAsQnc(ProxyOutput proxyOutput, String inviteContent, String sessionProgressContent, String serviceName, String clientIPAddress) {
        this.proxyOutput = proxyOutput;
        try {
            this.clientProfile = this.getClientProfileFromContent(inviteContent);
            this.serviceProfiles = this.getServiceProfilesFromContent(sessionProgressContent);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (proxyOutput != null) {
                proxyOutput.showError("Error while trying to create service and clientprofiles!...Matching stopped!");
            }
            return;
        }
        try {
            this.printDocument("Client profile", this.clientProfile);
            this.printDocument("Service profile", this.serviceProfiles[1]);
        }
        catch (Exception ex) {
            if (proxyOutput != null) {
                proxyOutput.showError("Error while displaying a service profile!");
            }
            ex.printStackTrace();
        }
    }

    public String determineInitialSdp(String sessionProgressContent) {
        String initialSdp = null;
        try {
            StringReader reader = new StringReader(sessionProgressContent);
            BufferedReader buffReader = new BufferedReader(reader);
            String line = buffReader.readLine();
            while (!line.startsWith("v=") && line != null) {
                line = buffReader.readLine();
            }
            if (line == null) {
                System.out.println("SDP parameters missing!");
                return null;
            }
            initialSdp = new String(line);
            line = buffReader.readLine();
            while (line != null && !line.startsWith("<?xml version=\"1.0\"")) {
                initialSdp = String.valueOf(initialSdp) + "\n" + line;
                line = buffReader.readLine();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        System.out.println("-------------\ndetermineInitialSdp: output = \n" + initialSdp);
        return initialSdp;
    }

    public String getFinalServiceProfile(String prackContent) {
        StringBuffer returnString = new StringBuffer();
        try {
            String sdpFile = "SimulatedResponses\\FinalServiceProfile.txt";
            if (!prackContent.contains("m=video")) {
                sdpFile = "SimulatedResponses\\FinalServiceProfile2.txt";
            }
            File file = new File(sdpFile);
            FileReader reader = new FileReader(file);
            int charRead = reader.read();
            while (charRead != -1) {
                returnString.append((char)charRead);
                charRead = reader.read();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnString.toString();
    }

    public String determineModifiedServiceProfile(String updateContent) {
        StringBuffer returnString = new StringBuffer();
        try {
            String sdpFile = "SimulatedResponses\\ModifiedServiceProfile.txt";
            File file = new File(sdpFile);
            FileReader reader = new FileReader(file);
            int charRead = reader.read();
            while (charRead != -1) {
                returnString.append((char)charRead);
                charRead = reader.read();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnString.toString();
    }

    public String adaptLOI(String reInviteContent) {
        StringBuffer returnString = new StringBuffer();
        try {
            String sdpFile = "SimulatedResponses\\AdaptLOI.txt";
            if (reInviteContent.contains("LOI:HIGH")) {
                sdpFile = "SimulatedResponses\\AdaptLOIHigh.txt";
            } else if (reInviteContent.contains("LOI:LOW")) {
                sdpFile = "SimulatedResponses\\AdaptLOILow.txt";
            }
            File file = new File(sdpFile);
            FileReader reader = new FileReader(file);
            int charRead = reader.read();
            while (charRead != -1) {
                returnString.append((char)charRead);
                charRead = reader.read();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnString.toString();
    }

    private Document getClientProfileFromContent(String inviteContent) throws IOException, SAXException, DOMException {
        StringReader reader = new StringReader(inviteContent);
        String header = new String();
        boolean foundHeader = false;
        reader.mark(1);
        int charRead = reader.read();
        while (!foundHeader && charRead != -1) {
            if (charRead == 60) {
                charRead = reader.read();
                while (charRead != -1 && charRead != 62) {
                    header = String.valueOf(header) + String.valueOf((char)charRead);
                    charRead = reader.read();
                }
                if (charRead == 62 && header.startsWith("?xml version=\"1.0\"")) {
                    foundHeader = true;
                }
            }
            if (!foundHeader) {
                reader.mark(1);
            }
            charRead = reader.read();
        }
        if (foundHeader) {
            reader.reset();
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(reader));
            this.clientProfile = parser.getDocument();
        }
        try {
            reader.close();
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        return this.clientProfile;
    }

    private Document[] getServiceProfilesFromContent(String sessionProgressContent) throws IOException, SAXException, DOMException {
        StringReader reader = new StringReader(sessionProgressContent);
        BufferedReader buffreader = new BufferedReader(reader);
        Vector<String> serviceProfiles = new Vector<String>();
        String line = buffreader.readLine();
        while (line != null && !line.startsWith("<?xml version=\"1.0\"")) {
            line = buffreader.readLine();
        }
        while (line != null) {
            String serviceProfile = line;
            line = buffreader.readLine();
            while (line != null && !line.startsWith("<?xml version=\"1.0\"")) {
                serviceProfile = String.valueOf(serviceProfile) + line;
                line = buffreader.readLine();
            }
            serviceProfiles.add(serviceProfile);
        }
        if (serviceProfiles.size() == 0) {
            return null;
        }
        Document[] serviceDocuments = new Document[serviceProfiles.size()];
        Iterator iterator = serviceProfiles.iterator();
        DOMParser parser = new DOMParser();
        int i = 0;
        while (iterator.hasNext()) {
            StringReader profileReader = new StringReader((String)iterator.next());
            parser.parse(new InputSource(profileReader));
            serviceDocuments[i] = parser.getDocument();
            ++i;
        }
        return serviceDocuments;
    }

    private void printDocument(String documentName, Document document) throws IOException, NullPointerException {
        StringWriter wrt = new StringWriter();
        XMLSerializer xmlSer = new XMLSerializer((Writer)wrt, new OutputFormat("xml", null, true));
        xmlSer.serialize(document);
        String documentString = wrt.getBuffer().toString();
        if (this.proxyOutput != null) {
            this.proxyOutput.showMessage("\n" + documentName + ":\n" + documentString);
        }
        System.out.println("\n" + documentName + ":\n" + documentString);
    }
}

