/*
 * Decompiled with CFR 0.152.
 */
package hr.fer.teletk.sipas.proxy;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public class ConfigurationHandler {
    private String configurationFile;
    private Properties configurationProperties;
    public final String STACK_ADDRESS_PROPERTY = "javax.sip.IP_ADDRESS";
    public final String STACK_NAME_PROPERTY = "javax.sip.STACK_NAME";
    public final String STACK_PORT_PROPERTY = "hr.fer.teletk.SIP_STACK_PORT";
    public final String STACK_TRANSPORT_PROPERTY = "hr.fer.teletk.SIP_STACK_TRANSPORT";
    public final String STACK_RETRANSMISSION_FILTER_PROPERTY = "javax.sip.RETRANSMISSON_FILTER";
    public final String STRIP_ROUTE_HEADER_PROPERTY = "gov.nist.javax.sip.STRIP_ROUTE_HEADER";
    public final String LOG_MESSAGE_CONTENT_PROPERTY = "gov.nist.javax.sip.LOG_MESSAGE_CONTENT";
    public final String STACK_SERVER_LOG_PROPERTY = "gov.nist.javax.sip.SERVER_LOG";
    public final String STACK_DEBUG_LOG_PROPERTY = "gov.nist.javax.sip.BAD_MESSAGE_LOG";
    public final String STACK_TRACE_LEVEL_PROPERTY = "gov.nist.javax.sip.TRACE_LEVEL";

    public ConfigurationHandler(String configurationFile) {
        this.configurationFile = configurationFile;
        this.configurationProperties = new Properties();
    }

    public void init() throws IOException, IllegalArgumentException {
        this.configurationProperties.load(new FileInputStream(this.configurationFile));
        if (!this.isStackAddressValid(this.configurationProperties.getProperty("javax.sip.IP_ADDRESS"))) {
            throw new IllegalArgumentException("Stack address value in the configuration invalid!");
        }
        if (!this.isStackNameValid(this.configurationProperties.getProperty("javax.sip.STACK_NAME"))) {
            throw new IllegalArgumentException("Stack name must be specified in the configuration!");
        }
        if (!this.isStackPortValid(this.configurationProperties.getProperty("hr.fer.teletk.SIP_STACK_PORT"))) {
            throw new IllegalArgumentException("Stack port number value in the configuration invalid!");
        }
        if (!this.isStackTransportValid(this.configurationProperties.getProperty("hr.fer.teletk.SIP_STACK_TRANSPORT"))) {
            throw new IllegalArgumentException("Stack transport value in the configuration invalid!");
        }
        if (!this.isStackRetransmissionFilterValid(this.configurationProperties.getProperty("javax.sip.RETRANSMISSON_FILTER"))) {
            throw new IllegalArgumentException("Stack retransmission filter value in the configuration invalid!");
        }
        if (!this.isStripRouteHeaderValid(this.configurationProperties.getProperty("gov.nist.javax.sip.STRIP_ROUTE_HEADER"))) {
            throw new IllegalArgumentException("Strip route header value in the configuration invalid!");
        }
        if (!this.isLogMessageContentValid(this.configurationProperties.getProperty("gov.nist.javax.sip.LOG_MESSAGE_CONTENT"))) {
            throw new IllegalArgumentException("Log message content value in the configuration invalid!");
        }
    }

    private boolean isStackAddressValid(String stackAddress) {
        String d;
        String c;
        String b;
        if (stackAddress == null) {
            return false;
        }
        if (stackAddress.compareTo("") == 0) {
            return false;
        }
        StringTokenizer addressTokenizer = new StringTokenizer(stackAddress, ".");
        String a = addressTokenizer.nextToken();
        try {
            b = addressTokenizer.nextToken();
            c = addressTokenizer.nextToken();
            d = addressTokenizer.nextToken();
        }
        catch (NoSuchElementException nsee) {
            return false;
        }
        try {
            int aint = Integer.parseInt(a);
            int bint = Integer.parseInt(b);
            int cint = Integer.parseInt(c);
            int dint = Integer.parseInt(d);
            if (aint <= -1 || bint <= -1 || cint <= -1 || dint <= -1) {
                return false;
            }
            if (aint >= 255 || bint >= 255 || cint >= 255 || dint >= 255) {
                return false;
            }
            if (aint == 0 || dint == 0) {
                return false;
            }
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private boolean isStackNameValid(String stackName) {
        return stackName != null;
    }

    private boolean isStackPortValid(String portString) {
        int port;
        if (portString == null) {
            return true;
        }
        try {
            port = Integer.parseInt(portString);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return port <= 65535 && port >= 1025;
    }

    private boolean isStackTransportValid(String transport) {
        if (transport == null) {
            return true;
        }
        if (transport.compareTo("") == 0) {
            return false;
        }
        return transport.compareToIgnoreCase("UDP") == 0 || transport.compareToIgnoreCase("TCP") == 0;
    }

    private boolean isStackRetransmissionFilterValid(String retransmissionFilter) {
        if (retransmissionFilter == null) {
            return true;
        }
        if (retransmissionFilter.compareTo("") == 0) {
            return false;
        }
        return retransmissionFilter.compareToIgnoreCase("ON") == 0 || retransmissionFilter.compareToIgnoreCase("OFF") == 0;
    }

    private boolean isStripRouteHeaderValid(String stripRouteHeader) {
        if (stripRouteHeader == null) {
            return true;
        }
        if (stripRouteHeader.compareTo("") == 0) {
            return false;
        }
        return stripRouteHeader.compareToIgnoreCase("true") == 0 || stripRouteHeader.compareToIgnoreCase("false") == 0;
    }

    private boolean isLogMessageContentValid(String logMessageContent) {
        if (logMessageContent == null) {
            return true;
        }
        if (logMessageContent.compareTo("") == 0) {
            return false;
        }
        return logMessageContent.compareToIgnoreCase("true") == 0 || logMessageContent.compareToIgnoreCase("false") == 0;
    }

    private boolean isStackTraceLevelValid(String stackTraceLevel) {
        if (stackTraceLevel == null) {
            return true;
        }
        if (stackTraceLevel.compareTo("") == 0) {
            return false;
        }
        return stackTraceLevel.compareTo("16") == 0 || stackTraceLevel.compareTo("32") == 0;
    }

    public String getStackAddress() {
        return this.configurationProperties.getProperty("javax.sip.IP_ADDRESS");
    }

    public void setStackAddress(String stackAddress) throws IllegalArgumentException {
        if (!this.isStackAddressValid(stackAddress)) {
            throw new IllegalArgumentException("Invalid stack address value");
        }
        this.configurationProperties.setProperty("javax.sip.IP_ADDRESS", stackAddress);
    }

    public String getStackName() {
        return this.configurationProperties.getProperty("javax.sip.STACK_NAME");
    }

    public void setStackName(String stackName) throws IllegalArgumentException {
        if (stackName != null) {
            if (stackName.compareTo("") != 0) {
                this.configurationProperties.setProperty("javax.sip.STACK_NAME", stackName);
            }
        } else {
            throw new IllegalArgumentException("Must specify stack name!");
        }
    }

    public int getStackPort() {
        String stackPort = this.configurationProperties.getProperty("hr.fer.teletk.SIP_STACK_PORT");
        if (stackPort == null) {
            return 5060;
        }
        return Integer.parseInt(stackPort);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setStackPort(String stackPort) throws IllegalArgumentException {
        if (stackPort != null) {
            if (stackPort.compareTo("") != 0) {
                if (!this.isStackPortValid(stackPort)) throw new IllegalArgumentException("Stack port number value invalid!");
                this.configurationProperties.setProperty("hr.fer.teletk.SIP_STACK_PORT", stackPort);
                return;
            } else {
                this.configurationProperties.remove("hr.fer.teletk.SIP_STACK_PORT");
            }
            return;
        } else {
            this.configurationProperties.remove("hr.fer.teletk.SIP_STACK_PORT");
        }
    }

    public String getStackTransport() {
        String stackTransport = this.configurationProperties.getProperty("hr.fer.teletk.SIP_STACK_TRANSPORT");
        if (stackTransport == null) {
            return "UDP";
        }
        return stackTransport;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setStackTransport(String stackTransport) throws IllegalArgumentException {
        if (stackTransport != null) {
            if (stackTransport.compareTo("") != 0) {
                if (!this.isStackTransportValid(stackTransport)) throw new IllegalArgumentException("Stack transport value invalid!");
                this.configurationProperties.setProperty("hr.fer.teletk.SIP_STACK_TRANSPORT", stackTransport);
                return;
            } else {
                this.configurationProperties.remove("hr.fer.teletk.SIP_STACK_TRANSPORT");
            }
            return;
        } else {
            this.configurationProperties.remove("hr.fer.teletk.SIP_STACK_TRANSPORT");
        }
    }

    public boolean getStackRetransmissionFilter() {
        String stackRetransmissionFilter = this.configurationProperties.getProperty("javax.sip.RETRANSMISSON_FILTER");
        if (stackRetransmissionFilter == null) {
            return false;
        }
        return stackRetransmissionFilter.compareToIgnoreCase("ON") == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setStackRetransmissionFilter(String stackRetransmissionFilter) throws IllegalArgumentException {
        if (stackRetransmissionFilter != null) {
            if (stackRetransmissionFilter.compareTo("") != 0) {
                if (!this.isStackRetransmissionFilterValid(stackRetransmissionFilter)) throw new IllegalArgumentException("Stack retransmission filter value invalid!");
                this.configurationProperties.setProperty("javax.sip.RETRANSMISSON_FILTER", stackRetransmissionFilter);
                return;
            } else {
                this.configurationProperties.remove("javax.sip.RETRANSMISSON_FILTER");
            }
            return;
        } else {
            this.configurationProperties.remove("javax.sip.RETRANSMISSON_FILTER");
        }
    }

    public boolean getStripRouteHeader() {
        String stripRouteHeader = this.configurationProperties.getProperty("gov.nist.javax.sip.STRIP_ROUTE_HEADER");
        if (stripRouteHeader == null) {
            return true;
        }
        return stripRouteHeader.compareToIgnoreCase("true") == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setStripRouteHeader(String stripRouteHeader) throws IllegalArgumentException {
        if (stripRouteHeader != null) {
            if (stripRouteHeader.compareTo("") != 0) {
                if (!this.isStripRouteHeaderValid(stripRouteHeader)) throw new IllegalArgumentException("Strip route header value invalid!");
                this.configurationProperties.setProperty("gov.nist.javax.sip.STRIP_ROUTE_HEADER", stripRouteHeader);
                return;
            } else {
                this.configurationProperties.remove("gov.nist.javax.sip.STRIP_ROUTE_HEADER");
            }
            return;
        } else {
            this.configurationProperties.remove("gov.nist.javax.sip.STRIP_ROUTE_HEADER");
        }
    }

    public boolean getLogMessageContent() {
        String logMessageContent = this.configurationProperties.getProperty("gov.nist.javax.sip.LOG_MESSAGE_CONTENT");
        if (logMessageContent == null) {
            return false;
        }
        return logMessageContent.compareToIgnoreCase("true") == 0;
    }

    public void setLogMessageContent(String logMessageContent) throws IllegalArgumentException {
        if (!this.isLogMessageContentValid(logMessageContent)) {
            throw new IllegalArgumentException("Invalid log message content value!");
        }
        this.configurationProperties.setProperty("gov.nist.javax.sip.LOG_MESSAGE_CONTENT", logMessageContent);
    }

    public String getStackServerLog() {
        return this.configurationProperties.getProperty("gov.nist.javax.sip.SERVER_LOG");
    }

    public void setStackServerLog(String stackServerLog) {
        if (stackServerLog != null) {
            if (stackServerLog.compareTo("") != 0) {
                this.configurationProperties.setProperty("gov.nist.javax.sip.SERVER_LOG", stackServerLog);
            } else {
                this.configurationProperties.remove("gov.nist.javax.sip.SERVER_LOG");
            }
        } else {
            this.configurationProperties.remove("gov.nist.javax.sip.SERVER_LOG");
        }
    }

    public String getStackDebugLog() {
        return this.configurationProperties.getProperty("gov.nist.javax.sip.BAD_MESSAGE_LOG");
    }

    public void setStackDebugLog(String stackDebugLog) {
        if (stackDebugLog != null) {
            if (stackDebugLog.compareTo("") != 0) {
                this.configurationProperties.setProperty("gov.nist.javax.sip.BAD_MESSAGE_LOG", stackDebugLog);
            } else {
                this.configurationProperties.remove("gov.nist.javax.sip.BAD_MESSAGE_LOG");
            }
        } else {
            this.configurationProperties.remove("gov.nist.javax.sip.BAD_MESSAGE_LOG");
        }
    }

    public String getStackTraceLevel() {
        String stackTraceLevel = this.configurationProperties.getProperty("gov.nist.javax.sip.TRACE_LEVEL");
        if (stackTraceLevel == null) {
            return "16";
        }
        return stackTraceLevel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setStackTraceLevel(String stackTraceLevel) {
        if (stackTraceLevel != null) {
            if (stackTraceLevel.compareTo("") != 0) {
                if (!this.isStackTraceLevelValid(stackTraceLevel)) throw new IllegalArgumentException("Stack trace level value invalid!");
                this.configurationProperties.setProperty("gov.nist.javax.sip.TRACE_LEVEL", stackTraceLevel);
                return;
            } else {
                this.configurationProperties.remove("gov.nist.javax.sip.TRACE_LEVEL");
            }
            return;
        } else {
            this.configurationProperties.remove("gov.nist.javax.sip.TRACE_LEVEL");
        }
    }

    public void commit() throws IOException, IllegalArgumentException {
        FileOutputStream configurationOutputStream = null;
        try {
            configurationOutputStream = new FileOutputStream(this.configurationFile);
        }
        catch (FileNotFoundException fnfe) {
            throw new IOException("Couldn't write the configuration! File not found!");
        }
        catch (SecurityException se) {
            throw new IOException("Couldn't write the configuration! Access denied!");
        }
        if (this.getStackAddress() == null) {
            throw new RuntimeException("Stack address must be specified!");
        }
        if (this.getStackName() == null) {
            throw new RuntimeException("Stack name must be specified!");
        }
        this.setStackPort(String.valueOf(this.getStackPort()));
        this.setStackTransport(this.getStackTransport());
        if (this.getStackRetransmissionFilter()) {
            this.setStackRetransmissionFilter("ON");
        } else {
            this.setStackRetransmissionFilter("OFF");
        }
        this.setStripRouteHeader(Boolean.toString(this.getStripRouteHeader()));
        this.setLogMessageContent(Boolean.toString(this.getLogMessageContent()));
        this.setStackTraceLevel(this.getStackTraceLevel());
        try {
            this.configurationProperties.store(configurationOutputStream, null);
        }
        catch (IOException ioe) {
            throw new IOException("An error occured while trying to save the configuration!");
        }
    }

    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }
}

