/*
 * Decompiled with CFR 0.152.
 */
package hr.fer.teletk.sipas.proxy;

import hr.fer.teletk.sipas.matching.SipAsQnc;
import hr.fer.teletk.sipas.proxy.ConfigurationHandler;
import hr.fer.teletk.sipas.proxy.ProxyOutput;
import hr.fer.teletk.sipas.proxy.RequestForwarding;
import hr.fer.teletk.sipas.proxy.RequestValidation;
import hr.fer.teletk.sipas.proxy.ResponseForwarding;
import hr.fer.teletk.sipas.proxy.TransactionsMapping;
import java.text.ParseException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.TooManyListenersException;
import java.util.Vector;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.PeerUnavailableException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionAlreadyExistsException;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.RouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;

public class Proxy
implements SipListener {
    private ConfigurationHandler configurationHandler;
    private ProxyOutput output;
    protected SipStack sipStack;
    protected SipProvider sipProvider;
    protected MessageFactory messageFactory;
    protected AddressFactory addressFactory;
    protected HeaderFactory headerFactory;
    protected RequestForwarding requestForwarding;
    protected ResponseForwarding responseForwarding;
    private ServerTransaction testServerTransaction = null;

    public Proxy(ConfigurationHandler configurationHandler, ProxyOutput output) throws Exception {
        if (configurationHandler == null) {
            throw new Exception("Can't start the proxy without the configuration!");
        }
        if (configurationHandler.getStackAddress() == null) {
            throw new Exception("Stack address not set in the configuration!");
        }
        if (configurationHandler.getStackAddress().compareTo("") == 0) {
            throw new Exception("Stack address not set in the configuration!");
        }
        if (configurationHandler.getStackName() == null) {
            throw new Exception("Stack name not set in the configuration!");
        }
        if (configurationHandler.getStackName().compareTo("") == 0) {
            throw new Exception("Stack name not set in the configuration!");
        }
        this.configurationHandler = configurationHandler;
        this.output = output;
        this.requestForwarding = new RequestForwarding(this);
        this.responseForwarding = new ResponseForwarding(this);
    }

    public void start() throws Exception {
        SipFactory sipFactory = SipFactory.getInstance();
        sipFactory.setPathName("gov.nist");
        try {
            this.addressFactory = sipFactory.createAddressFactory();
            this.headerFactory = sipFactory.createHeaderFactory();
            this.messageFactory = sipFactory.createMessageFactory();
            this.sipStack = sipFactory.createSipStack(this.configurationHandler.getConfigurationProperties());
        }
        catch (PeerUnavailableException pue) {
            pue.printStackTrace();
            throw new Exception("SIP stack implementation could not be created!");
        }
        ListeningPoint listeningPoint = this.sipStack.createListeningPoint(this.configurationHandler.getStackPort(), this.configurationHandler.getStackTransport());
        try {
            this.sipProvider = this.sipStack.createSipProvider(listeningPoint);
        }
        catch (ObjectInUseException oiue) {
            oiue.printStackTrace();
            throw new Exception("SIP stack initialization problem - cannot listen at the specified listening point!");
        }
        try {
            this.sipProvider.addSipListener((SipListener)this);
        }
        catch (TooManyListenersException tmle) {
            tmle.printStackTrace();
            throw new Exception("SIP stack initialization problem - another listener allready registered!");
        }
        System.out.println("SIP stack started!");
    }

    public void stop() throws Exception {
        if (this.sipStack == null) {
            return;
        }
        if (this.sipProvider != null) {
            this.sipProvider.removeSipListener((SipListener)this);
            try {
                this.sipStack.deleteSipProvider(this.sipProvider);
            }
            catch (ObjectInUseException oiue) {
                oiue.printStackTrace();
                throw new Exception("Couldn't stop the stack - provider in use!");
            }
            Iterator listeningPoints = this.sipStack.getListeningPoints();
            if (listeningPoints != null && listeningPoints.hasNext()) {
                ListeningPoint listeningPoint = (ListeningPoint)listeningPoints.next();
                try {
                    this.sipStack.deleteListeningPoint(listeningPoint);
                }
                catch (ObjectInUseException oiue) {
                    oiue.printStackTrace();
                    throw new Exception("Couldn't stop the stack - listening point in use!");
                }
            }
            this.sipStack = null;
        }
    }

    public void processRequest(RequestEvent requestEvent) {
        ServerTransaction serverTransaction;
        Request request = requestEvent.getRequest();
        CSeqHeader cSeqHeader = (CSeqHeader)request.getHeader("CSeq");
        this.testServerTransaction = serverTransaction = requestEvent.getServerTransaction();
        System.out.println("Received request:");
        System.out.println("-------------------------------------");
        System.out.println(request.toString());
        System.out.println("-------------------------------------");
        try {
            URI requestURI;
            ListIterator routes;
            RequestValidation requestValidation = new RequestValidation(this);
            if (!requestValidation.validateRequest(request, serverTransaction)) {
                if (this.output != null) {
                    this.output.showMessage("Proxy-processRequest: invalid request discardedand an error code was sent back!");
                }
                return;
            }
            if (request.getMethod().equals("ACK") && ((routes = request.getHeaders("Route")) == null || !routes.hasNext())) {
                if (this.output != null) {
                    this.output.showError("Proxy-processRequest: the request is an ACK targeted for the proxy, we ignore it!");
                }
                return;
            }
            if (serverTransaction == null) {
                TransactionsMapping transactionsMapping;
                String method = request.getMethod();
                if (method.equals("INVITE") || method.equals("SUBSCRIBE")) {
                    try {
                        serverTransaction = this.sipProvider.getNewServerTransaction(request);
                        transactionsMapping = (TransactionsMapping)serverTransaction.getDialog().getApplicationData();
                        if (transactionsMapping == null) {
                            transactionsMapping = new TransactionsMapping(serverTransaction);
                        }
                    }
                    catch (TransactionAlreadyExistsException taee) {
                        if (this.output != null) {
                            this.output.showError("Proxy-processRequest: the request is a retransmission, we drop it!");
                        }
                        taee.printStackTrace();
                    }
                    catch (TransactionUnavailableException tue) {
                        if (this.output != null) {
                            this.output.showError("Proxy-processRequest: unable to create the server transaction for the request! Ignoring request!");
                        }
                        tue.printStackTrace();
                    }
                } else {
                    try {
                        serverTransaction = this.sipProvider.getNewServerTransaction(request);
                        transactionsMapping = (TransactionsMapping)serverTransaction.getDialog().getApplicationData();
                        if (transactionsMapping == null && this.output != null) {
                            this.output.showError("Created new server transaction for the request but cannot find TransactionsMapping!");
                        }
                    }
                    catch (TransactionAlreadyExistsException taee) {
                        if (this.output != null) {
                            this.output.showError("Proxy-processRequest: the request is a retransmission, we drop it!");
                        }
                        taee.printStackTrace();
                    }
                    catch (TransactionUnavailableException tue) {
                        if (this.output != null) {
                            this.output.showError("Proxy-processRequest: unable to create the server transaction for the request! Ignoring request!");
                        }
                        tue.printStackTrace();
                    }
                }
            }
            if ((routes = request.getHeaders("Route")) != null && routes.hasNext()) {
                Iterator listeningPoints;
                RouteHeader routeHeader = (RouteHeader)routes.next();
                Address routeAddress = routeHeader.getAddress();
                SipURI routeSipURI = (SipURI)routeAddress.getURI();
                String host = routeSipURI.getHost();
                int port = routeSipURI.getPort();
                if (this.sipStack.getIPAddress().equals(host) && (listeningPoints = this.sipStack.getListeningPoints()) != null) {
                    while (listeningPoints.hasNext()) {
                        ListeningPoint listeningPoint = (ListeningPoint)listeningPoints.next();
                        if (listeningPoint.getPort() != port) continue;
                        if (this.output != null) {
                            this.output.showMessage("Proxy-processRequest: the first route from the RouteHeader matches the proxy. We remove it.");
                        }
                        routes.remove();
                        break;
                    }
                }
            }
            if ((requestURI = request.getRequestURI()).isSipURI()) {
                SipURI requestSipURI = (SipURI)requestURI;
                requestSipURI.getMAddrParam();
            }
            Vector<URI> targetURIList = new Vector<URI>();
            if (requestURI.isSipURI()) {
                String updateContent;
                String reInviteContent;
                SipAsQnc sipAsQnc;
                String prackContent;
                SipURI requestSipURI = (SipURI)requestURI;
                URI targetURI = requestURI;
                targetURIList.addElement(targetURI);
                if (requestSipURI.getMAddrParam() != null && this.output != null) {
                    this.output.showMessage("Proxy-processRequest: the only target is the Request-URI (mAddr parameter)!");
                }
                TransactionsMapping transactionsMapping = (TransactionsMapping)serverTransaction.getDialog().getApplicationData();
                if (serverTransaction != null && serverTransaction.getDialog() != null && request.getMethod().equals("PRACK") && transactionsMapping.getState() == 0) {
                    prackContent = new String(request.getRawContent());
                    if (prackContent == null) {
                        System.out.println("Prvi prack content je null, iako ne bi trebao bit...");
                    }
                    System.out.println("++++++++++++++++++++++++++++++");
                    System.out.println(prackContent);
                    System.out.println("++++++++++++++++++++++++++++++");
                    transactionsMapping = (TransactionsMapping)serverTransaction.getDialog().getApplicationData();
                    sipAsQnc = transactionsMapping.getSipAsQnc();
                    long t1 = System.currentTimeMillis();
                    prackContent = sipAsQnc.getFinalServiceProfile(prackContent);
                    if (prackContent == null) {
                        System.out.println("PrackContent 2 je null, pogledaj zasto");
                    }
                    long t2 = System.currentTimeMillis();
                    System.out.println("++++++++++++++++++++++++++++Optimization:" + (t2 - t1));
                    ContentTypeHeader contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                    if (contentTypeHeader == null) {
                        System.out.println("ContentTypeHeader 2 je null");
                    }
                    request.removeContent();
                    request.setContent((Object)prackContent, contentTypeHeader);
                } else if (serverTransaction != null && serverTransaction.getDialog() != null && request.getMethod().equals("PRACK") && transactionsMapping.getState() == 6) {
                    prackContent = new String(request.getRawContent());
                    transactionsMapping = (TransactionsMapping)serverTransaction.getDialog().getApplicationData();
                    sipAsQnc = transactionsMapping.getSipAsQnc();
                    long t1 = System.currentTimeMillis();
                    if ((prackContent = sipAsQnc.getFinalServiceProfile(prackContent)) == null) {
                        System.out.println("PrackContent je null, pogledaj zasto");
                    }
                    long t2 = System.currentTimeMillis();
                    System.out.println("++++++++++++++++++++++++++++Optimization2:" + (t2 - t1));
                    ContentTypeHeader contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                    if (contentTypeHeader == null) {
                        System.out.println("ContentTypeHeader je null");
                    }
                    request.removeContent();
                    request.setContent((Object)prackContent, contentTypeHeader);
                } else if (request.getMethod().equals("INVITE") && (transactionsMapping.getState() == 3 || transactionsMapping.getState() == 1)) {
                    reInviteContent = new String(request.getRawContent());
                    sipAsQnc = transactionsMapping.getSipAsQnc();
                    sipAsQnc.setNewClientProfile(reInviteContent);
                    System.out.println("\n----- STATE " + transactionsMapping.getState() + " -----\n");
                    if (transactionsMapping.getState() == 3) {
                        transactionsMapping.setState(5);
                    } else {
                        transactionsMapping.setState(6);
                    }
                    System.out.println("\n----- STATE " + transactionsMapping.getState() + " -----\n");
                } else if (serverTransaction != null && serverTransaction.getDialog() != null && request.getMethod().equals("UPDATE") && serverTransaction.getDialog().getState().equals(DialogState.CONFIRMED) && serverTransaction.getDialog().getRemoteSequenceNumber() == 4 && transactionsMapping.getState() == 0) {
                    System.out.println("Primio UPDATE poruku sa sequence brojem: " + serverTransaction.getDialog().getRemoteSequenceNumber());
                    updateContent = new String(request.getRawContent());
                    transactionsMapping = (TransactionsMapping)serverTransaction.getDialog().getApplicationData();
                    sipAsQnc = transactionsMapping.getSipAsQnc();
                    updateContent = sipAsQnc.determineModifiedServiceProfile(updateContent);
                    ContentTypeHeader contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                    request.setContent((Object)updateContent, contentTypeHeader);
                } else if (serverTransaction != null && serverTransaction.getDialog() != null && request.getMethod().equals("UPDATE") && serverTransaction.getDialog().getState() != null && serverTransaction.getDialog().getState().equals(DialogState.CONFIRMED) && request.getHeader("From").toString().contains("gallery")) {
                    if (transactionsMapping.getState() == 1 || transactionsMapping.getState() == 3) {
                        reInviteContent = new String(request.getRawContent());
                        transactionsMapping = (TransactionsMapping)serverTransaction.getDialog().getApplicationData();
                        sipAsQnc = transactionsMapping.getSipAsQnc();
                        long t1 = System.currentTimeMillis();
                        reInviteContent = sipAsQnc.adaptLOI(reInviteContent);
                        long t2 = System.currentTimeMillis();
                        System.out.println("++++++++++++++++++++++++++++Adapt LOI:" + (t2 - t1));
                        ContentTypeHeader contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                        request.removeContent();
                        request.setContent((Object)reInviteContent, contentTypeHeader);
                        if (transactionsMapping.getState() == 1) {
                            System.out.println("\n----- STATE " + transactionsMapping.getState() + " -----\n");
                            transactionsMapping.setState(2);
                            System.out.println("\n----- STATE " + transactionsMapping.getState() + " -----\n");
                        } else {
                            System.out.println("\n----- STATE " + transactionsMapping.getState() + " -----\n");
                            transactionsMapping.setState(1);
                            System.out.println("\n----- STATE " + transactionsMapping.getState() + " -----\n");
                        }
                    }
                } else if (serverTransaction != null && serverTransaction.getDialog() != null && request.getMethod().equals("UPDATE") && serverTransaction.getDialog().getState() != null && serverTransaction.getDialog().getState().equals(DialogState.CONFIRMED) && !request.getHeader("From").toString().contains("gallery")) {
                    if (transactionsMapping.getState() == 3) {
                        updateContent = new String(request.getRawContent());
                        transactionsMapping = (TransactionsMapping)serverTransaction.getDialog().getApplicationData();
                        sipAsQnc = transactionsMapping.getSipAsQnc();
                        long t1 = System.currentTimeMillis();
                        updateContent = sipAsQnc.determineModifiedServiceProfile(updateContent);
                        long t2 = System.currentTimeMillis();
                        System.out.println("++++++++++++++++++++++++++++determine modified profile:" + (t2 - t1));
                        ContentTypeHeader contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                        request.removeContent();
                        request.setContent((Object)updateContent, contentTypeHeader);
                        System.out.println("\n----- STATE " + transactionsMapping.getState() + " -----\n");
                        transactionsMapping.setState(4);
                        System.out.println("\n----- STATE " + transactionsMapping.getState() + " -----\n");
                    } else if (transactionsMapping.getState() == 4) {
                        System.out.println("\n----- STATE " + transactionsMapping.getState() + " -----\n");
                        transactionsMapping.setState(3);
                        System.out.println("\n----- STATE " + transactionsMapping.getState() + " -----\n");
                    } else if (transactionsMapping.getState() == 7) {
                        System.out.println("Primio UPDATE poruku sa sequence brojem: " + serverTransaction.getDialog().getRemoteSequenceNumber());
                        updateContent = new String(request.getRawContent());
                        transactionsMapping = (TransactionsMapping)serverTransaction.getDialog().getApplicationData();
                        sipAsQnc = transactionsMapping.getSipAsQnc();
                        long t1 = System.currentTimeMillis();
                        updateContent = sipAsQnc.determineModifiedServiceProfile(updateContent);
                        long t2 = System.currentTimeMillis();
                        System.out.println("++++++++++++++++++++++++++++determine modified profile:" + (t2 - t1));
                        ContentTypeHeader contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                        request.setContent((Object)updateContent, contentTypeHeader);
                    }
                }
                this.requestForwarding.forwardRequest(targetURIList, request, serverTransaction, true);
                return;
            }
            if (request.getMethod().equals("BYE")) {
                if (serverTransaction == null) {
                    if (this.output != null) {
                        this.output.showMessage("Proxy-processRequest: null server transaction for BYE!");
                    }
                    return;
                }
                Dialog d = serverTransaction.getDialog();
                TransactionsMapping transactionsMapping = (TransactionsMapping)d.getApplicationData();
                Dialog peerDialog = transactionsMapping.getPeerDialog(serverTransaction);
                Request clonedRequest = (Request)request.clone();
                FromHeader from = (FromHeader)clonedRequest.getHeader("From");
                from.removeParameter("tag");
                ToHeader to = (ToHeader)clonedRequest.getHeader("To");
                to.removeParameter("tag");
                ViaHeader via = this.getStackViaHeader();
                clonedRequest.addHeader((Header)via);
                if (peerDialog.getState() != null) {
                    ClientTransaction newClientTransaction = this.sipProvider.getNewClientTransaction(clonedRequest);
                    transactionsMapping.addMapping(serverTransaction, newClientTransaction);
                    peerDialog.sendRequest(newClientTransaction);
                    return;
                }
                if (this.output != null) {
                    this.output.showMessage("Proxy-processRequest: bad dialog state - client sending BYE before dialog establishment!");
                }
                return;
            }
        }
        catch (Exception ex) {
            try {
                if (this.output != null) {
                    this.output.showError("Proxy-processRequest internal error: " + ex.getMessage());
                }
                ex.printStackTrace();
                Response response = this.messageFactory.createResponse(500, request);
                if (serverTransaction != null) {
                    serverTransaction.sendResponse(response);
                } else {
                    this.sipProvider.sendResponse(response);
                }
                if (this.output != null) {
                    this.output.showError("Proxy-processRequest: 500 SERVER_INTERNAL_ERROR replied!" + response.toString());
                }
            }
            catch (Exception iex) {
                iex.printStackTrace();
            }
        }
    }

    public void processResponse(ResponseEvent responseEvent) {
        try {
            TransactionsMapping transactionsMapping;
            Response response = responseEvent.getResponse();
            ClientTransaction clientTransaction = responseEvent.getClientTransaction();
            if (this.output != null) {
                this.output.showMessage("Proxy-processResponse: processing response...\n" + response.toString());
            }
            System.out.println("Received response:");
            System.out.println("-------------------------------------");
            System.out.println(response.toString());
            System.out.println("-------------------------------------");
            CSeqHeader cSeqHeader = (CSeqHeader)response.getHeader("CSeq");
            if (clientTransaction != null && clientTransaction.getDialog() != null && cSeqHeader.getMethod().equals("UPDATE") && response.getHeader("To").toString().contains("gallery")) {
                transactionsMapping = (TransactionsMapping)clientTransaction.getDialog().getApplicationData();
                if (transactionsMapping.getState() == 0) {
                    if (cSeqHeader.getSequenceNumber() == 4) {
                        System.out.println("\n---------------------------------------");
                        System.out.println("   STATE " + transactionsMapping.getState());
                        System.out.println("---------------------------------------\n");
                        transactionsMapping.setState(1);
                        System.out.println("\n---------------------------------------");
                        System.out.println("   STATE " + transactionsMapping.getState());
                        System.out.println("---------------------------------------\n");
                    }
                } else if (transactionsMapping.getState() == 2) {
                    System.out.println("\n---------------------------------------");
                    System.out.println("   STATE " + transactionsMapping.getState());
                    System.out.println("---------------------------------------\n");
                    transactionsMapping.setState(3);
                    System.out.println("\n---------------------------------------");
                    System.out.println("   STATE " + transactionsMapping.getState());
                    System.out.println("---------------------------------------\n");
                } else if (transactionsMapping.getState() == 5) {
                    System.out.println("\n---------------------------------------");
                    System.out.println("   STATE " + transactionsMapping.getState());
                    System.out.println("---------------------------------------\n");
                    transactionsMapping.setState(3);
                    System.out.println("\n---------------------------------------");
                    System.out.println("   STATE " + transactionsMapping.getState());
                    System.out.println("---------------------------------------\n");
                } else if (transactionsMapping.getState() == 6) {
                    System.out.println("\n---------------------------------------");
                    System.out.println("   STATE " + transactionsMapping.getState());
                    System.out.println("---------------------------------------\n");
                    transactionsMapping.setState(7);
                    System.out.println("\n---------------------------------------");
                    System.out.println("   STATE " + transactionsMapping.getState());
                    System.out.println("---------------------------------------\n");
                } else if (transactionsMapping.getState() == 7) {
                    System.out.println("\n---------------------------------------");
                    System.out.println("   STATE " + transactionsMapping.getState());
                    System.out.println("---------------------------------------\n");
                    transactionsMapping.setState(1);
                    System.out.println("\n---------------------------------------");
                    System.out.println("   STATE " + transactionsMapping.getState());
                    System.out.println("---------------------------------------\n");
                }
            }
            if (clientTransaction != null && clientTransaction.getDialog() != null && response.getStatusCode() == 183) {
                transactionsMapping = (TransactionsMapping)clientTransaction.getDialog().getApplicationData();
                if (transactionsMapping.getState() == 0) {
                    String sessionProgressContent = new String(response.getRawContent());
                    transactionsMapping = (TransactionsMapping)clientTransaction.getDialog().getApplicationData();
                    ServerTransaction serverTransaction = transactionsMapping.getServerTransaction(clientTransaction);
                    Request inviteRequest = serverTransaction.getRequest();
                    String inviteContent = new String(inviteRequest.getRawContent());
                    SipURI inviteRequestURI = (SipURI)inviteRequest.getRequestURI();
                    String serviceName = inviteRequestURI.getUser();
                    if (serviceName.indexOf(".") != -1) {
                        serviceName = serviceName.substring(0, serviceName.indexOf("."));
                    }
                    String clientIPAddress = null;
                    try {
                        FromHeader fromHeader = (FromHeader)inviteRequest.getHeader("From");
                        Address fromHeaderAddress = fromHeader.getAddress();
                        SipURI fromHeaderURI = (SipURI)fromHeaderAddress.getURI();
                        clientIPAddress = fromHeaderURI.getHost();
                    }
                    catch (ClassCastException cce) {
                        cce.printStackTrace();
                    }
                    if (clientIPAddress == null) {
                        if (this.output != null) {
                            this.output.showError("Couldn't get client's IP address! Just forwarding response!");
                        }
                        this.responseForwarding.forwardResponse(response, clientTransaction);
                        return;
                    }
                    SipAsQnc sipAsQnc = new SipAsQnc(this.getOutput(), inviteContent, sessionProgressContent, serviceName, clientIPAddress);
                    if (sipAsQnc == null) {
                        if (this.output != null) {
                            this.output.showError("Couldn't create SipAsQnc! Just forwarding response!");
                        }
                        this.responseForwarding.forwardResponse(response, clientTransaction);
                        return;
                    }
                    transactionsMapping.setSipAsQnc(sipAsQnc);
                    long t1 = System.currentTimeMillis();
                    sessionProgressContent = sipAsQnc.determineInitialSdp(sessionProgressContent);
                    long t2 = System.currentTimeMillis();
                    System.out.println("++++++++++++++++++++++++++++determineInitialSdp:" + (t2 - t1));
                    if (sessionProgressContent != null) {
                        ContentTypeHeader contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                        response.setContent((Object)sessionProgressContent, contentTypeHeader);
                    }
                } else if (transactionsMapping.getState() == 5) {
                    String sessionProgressContent = new String(response.getRawContent());
                    SipAsQnc sipAsQnc = transactionsMapping.getSipAsQnc();
                    long t1 = System.currentTimeMillis();
                    sessionProgressContent = sipAsQnc.adaptLOI(sessionProgressContent);
                    long t2 = System.currentTimeMillis();
                    System.out.println("++++++++++++++++++++++++++++Adapt LOI2:" + (t2 - t1));
                    ContentTypeHeader contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                    response.removeContent();
                    response.setContent((Object)sessionProgressContent, contentTypeHeader);
                } else if (transactionsMapping.getState() == 6) {
                    String sessionProgressContent = new String(response.getRawContent());
                    SipAsQnc sipAsQnc = transactionsMapping.getSipAsQnc();
                    long t1 = System.currentTimeMillis();
                    sessionProgressContent = sipAsQnc.determineInitialSdp(sessionProgressContent);
                    long t2 = System.currentTimeMillis();
                    System.out.println("++++++++++++++++++++++++++++determineInitialSdp2:" + (t2 - t1));
                    ContentTypeHeader contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                    response.removeContent();
                    response.setContent((Object)sessionProgressContent, contentTypeHeader);
                }
            }
            this.responseForwarding.forwardResponse(response, clientTransaction);
        }
        catch (Exception ex) {
            if (this.output != null) {
                this.output.showError("\nProxy-processResponse: internal error!");
            }
            ex.printStackTrace();
        }
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        if (this.output != null) {
            this.output.showMessage("Timeout received...");
        }
        TransactionsMapping transactionsMapping = null;
        if (timeoutEvent.isServerTransaction()) {
            ServerTransaction serverTransaction = timeoutEvent.getServerTransaction();
            Dialog dialog = serverTransaction.getDialog();
            if (dialog != null) {
                transactionsMapping = (TransactionsMapping)dialog.getApplicationData();
                transactionsMapping.removeMapping(serverTransaction);
            }
        } else {
            ClientTransaction clientTransaction = timeoutEvent.getClientTransaction();
            Dialog dialog = clientTransaction.getDialog();
            ServerTransaction st = null;
            if (dialog != null) {
                transactionsMapping = (TransactionsMapping)dialog.getApplicationData();
                if (transactionsMapping != null) {
                    st = transactionsMapping.getServerTransaction(clientTransaction);
                }
                if (st == null) {
                    if (this.output != null) {
                        this.output.showMessage("Unable to retrieve a matching server transaction for a client transaction timeout! Cannot process timeout!");
                    }
                    return;
                }
            } else {
                if (this.output != null) {
                    this.output.showMessage("Unable to retrieve a matching server transaction for a client transaction timeout! Cannot process timeout!");
                }
                return;
            }
            Request request = st.getRequest();
            transactionsMapping.removeMapping(clientTransaction);
            if (!transactionsMapping.hasMapping(st)) {
                try {
                    Response response = this.messageFactory.createResponse(408, request);
                    st.sendResponse(response);
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
                catch (SipException ex1) {
                    ex1.printStackTrace();
                }
            }
        }
    }

    protected AddressFactory getAddressFactory() {
        return this.addressFactory;
    }

    protected HeaderFactory getHeaderFactory() {
        return this.headerFactory;
    }

    protected MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    protected SipProvider getSipProvider() {
        return this.sipProvider;
    }

    protected SipStack getSipStack() {
        return this.sipStack;
    }

    protected ProxyOutput getOutput() {
        return this.output;
    }

    public ViaHeader getStackViaHeader() {
        try {
            ListeningPoint lp = (ListeningPoint)this.sipStack.getListeningPoints().next();
            String host = this.sipStack.getIPAddress();
            int port = lp.getPort();
            String transport = lp.getTransport();
            return this.headerFactory.createViaHeader(host, port, transport, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

