/*
 * Decompiled with CFR 0.152.
 */
package hr.fer.teletk.sipas.proxy;

import gov.nist.javax.sip.Utils;
import hr.fer.teletk.sipas.proxy.Proxy;
import hr.fer.teletk.sipas.proxy.TransactionsMapping;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.ListeningPoint;
import javax.sip.ServerTransaction;
import javax.sip.SipStack;
import javax.sip.Transaction;
import javax.sip.TransactionState;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;

public class RequestForwarding {
    private Proxy proxy;

    public RequestForwarding(Proxy proxy) {
        this.proxy = proxy;
    }

    public void forwardRequest(Vector targetsURIList, Request request, ServerTransaction serverTransaction, boolean statefullForwarding) {
        System.out.println("Forwarding request:");
        System.out.println("-------------------------------------");
        System.out.println(request.toString());
        System.out.println("-------------------------------------");
        MessageFactory messageFactory = this.proxy.getMessageFactory();
        HeaderFactory headerFactory = this.proxy.getHeaderFactory();
        SipStack sipStack = this.proxy.getSipStack();
        AddressFactory addressFactory = this.proxy.getAddressFactory();
        URI requestURI = request.getRequestURI();
        Iterator parametersNames = null;
        String transport = null;
        if (requestURI.isSipURI()) {
            parametersNames = ((SipURI)requestURI).getParameterNames();
            transport = ((SipURI)requestURI).getTransportParam();
        }
        try {
            int i = 0;
            while (i < targetsURIList.size()) {
                RouteHeader firstRouteHeader;
                Address routeAddress;
                URI routeURI;
                ListIterator routes;
                URI targetURI = (URI)targetsURIList.elementAt(i);
                Request clonedRequest = (Request)request.clone();
                MaxForwardsHeader maxForwards = (MaxForwardsHeader)clonedRequest.getHeader("Max-Forwards");
                if (maxForwards == null) {
                    if (this.proxy.getOutput() != null) {
                        this.proxy.getOutput().showMessage("RequestForwarding-forwardRequest: MaxForwardHeader created and added to the cloned request.");
                    }
                    maxForwards = headerFactory.createMaxForwardsHeader(70);
                    clonedRequest.addHeader((Header)maxForwards);
                } else {
                    if (this.proxy.getOutput() != null) {
                        this.proxy.getOutput().showMessage("RequestForwarding-forwardRequest:  MaxForwardHeader value decremented by one.");
                    }
                    maxForwards.setMaxForwards(maxForwards.getMaxForwards() - 1);
                }
                String stackIPAddress = sipStack.getIPAddress();
                ListeningPoint lp = this.proxy.getSipProvider().getListeningPoint();
                SipURI sipURI = addressFactory.createSipURI(null, stackIPAddress);
                sipURI.setTransportParam(lp.getTransport());
                sipURI.setPort(lp.getPort());
                sipURI.setLrParam();
                Address address = addressFactory.createAddress(null, (URI)sipURI);
                RecordRouteHeader recordRouteHeader = headerFactory.createRecordRouteHeader(address);
                ListIterator recordRouteHeaders = clonedRequest.getHeaders("Record-Route");
                clonedRequest.removeHeader("Record-Route");
                Vector<RecordRouteHeader> v = new Vector<RecordRouteHeader>();
                v.addElement(recordRouteHeader);
                if (recordRouteHeaders != null) {
                    while (recordRouteHeaders.hasNext()) {
                        recordRouteHeader = (RecordRouteHeader)recordRouteHeaders.next();
                        v.addElement(recordRouteHeader);
                    }
                }
                int j = 0;
                while (j < v.size()) {
                    recordRouteHeader = (RecordRouteHeader)v.elementAt(j);
                    clonedRequest.addHeader((Header)recordRouteHeader);
                    ++j;
                }
                if (this.proxy.getOutput() != null) {
                    this.proxy.getOutput().showMessage("RequestForwarding-forwardRequest: record-route header created and added to the cloned request.");
                }
                if ((routes = clonedRequest.getHeaders("Route")) != null && routes.hasNext() && (routeURI = (routeAddress = (firstRouteHeader = (RouteHeader)routes.next()).getAddress()).getURI()).isSipURI() && !((SipURI)routeURI).hasLrParam()) {
                    RouteHeader lastRouteHeader = headerFactory.createRouteHeader(addressFactory.createAddress(clonedRequest.getRequestURI()));
                    clonedRequest.addHeader((Header)lastRouteHeader);
                    clonedRequest.setRequestURI(firstRouteHeader.getAddress().getURI());
                    if (this.proxy.getOutput() != null) {
                        this.proxy.getOutput().showMessage("RequestForwarding-forwardRequest:Request-URI placed into last Route header and firstRoute header popped into Request-URI.");
                    }
                }
                ViaHeader viaHeader = null;
                if (clonedRequest.getMethod().equals("CANCEL")) {
                    viaHeader = headerFactory.createViaHeader(stackIPAddress, lp.getPort(), lp.getTransport(), null);
                    clonedRequest.removeHeader("Via");
                } else {
                    viaHeader = headerFactory.createViaHeader(stackIPAddress, lp.getPort(), lp.getTransport(), Utils.generateBranchId());
                }
                if (viaHeader != null) {
                    clonedRequest.addHeader((Header)viaHeader);
                }
                if (this.proxy.getOutput() != null) {
                    this.proxy.getOutput().showMessage("RequestForwarding-forwardRequest: proxy's Via header added before existing Via headers.");
                }
                if (statefullForwarding) {
                    this.forwardRequestStatefully(clonedRequest, request, serverTransaction);
                } else {
                    this.forwardRequestStatelessly(clonedRequest, request, serverTransaction);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            try {
                if (this.proxy.getOutput() != null) {
                    this.proxy.getOutput().showError("RequestForwarding-forwardRequest: " + ex.getMessage());
                    Response response = messageFactory.createResponse(500, request);
                    if (serverTransaction != null) {
                        serverTransaction.sendResponse(response);
                    } else {
                        this.proxy.getSipProvider().sendResponse(response);
                    }
                    if (this.proxy.getOutput() != null) {
                        this.proxy.getOutput().showError("RequestForwarding-forwardRequest: 500 SERVER_INTERNAL_ERROR replied!" + response.toString());
                    }
                }
                ex.printStackTrace();
            }
            catch (Exception iex) {
                iex.printStackTrace();
            }
        }
    }

    private void forwardRequestStatefully(Request clonedRequest, Request originalRequest, ServerTransaction serverTransaction) {
        MessageFactory messageFactory = this.proxy.getMessageFactory();
        HeaderFactory headerFactory = this.proxy.getHeaderFactory();
        AddressFactory addressFactory = this.proxy.getAddressFactory();
        SipStack sipStack = this.proxy.getSipStack();
        try {
            if (serverTransaction == null && !clonedRequest.getMethod().equals("MESSAGE")) {
                if (this.proxy.getOutput() != null) {
                    this.proxy.getOutput().showMessage("RequestForwarding-forwardRequestStatefully: the cloned request does not have a server transaction, so we drop the request!");
                }
                return;
            }
            if (originalRequest.getMethod().equals("CANCEL")) {
                Response response = messageFactory.createResponse(487, originalRequest);
                CSeqHeader cSeqHeader = (CSeqHeader)response.getHeader("CSeq");
                cSeqHeader.setMethod("INVITE");
                serverTransaction.sendResponse(response);
                if (this.proxy.getOutput() != null) {
                    this.proxy.getOutput().showMessage("RequestForwarding-forwardRequestStatefully:487 Request Terminated replied to theCANCEL:\n" + response.toString());
                }
            }
            FromHeader fromHeader = (FromHeader)clonedRequest.getHeader("From");
            ToHeader toHeader = (ToHeader)clonedRequest.getHeader("To");
            CSeqHeader cseqHeader = (CSeqHeader)clonedRequest.getHeader("CSeq");
            String method = clonedRequest.getMethod();
            Dialog dialog = null;
            if (serverTransaction != null) {
                dialog = serverTransaction.getDialog();
            }
            DialogState dialogState = null;
            if (dialog != null) {
                dialogState = dialog.getState();
            }
            if (dialogState == null) {
                if (this.proxy.getOutput() != null) {
                    this.proxy.getOutput().showMessage("RequestForwarding-forwardRequestStatefully: cloned request forwarded statefully through a new client transaction!");
                }
                ClientTransaction clientTransaction = this.proxy.getSipProvider().getNewClientTransaction(clonedRequest);
                clientTransaction.sendRequest();
                if (dialog != null) {
                    TransactionsMapping transactionsMapping = (TransactionsMapping)serverTransaction.getDialog().getApplicationData();
                    transactionsMapping.addMapping(serverTransaction, clientTransaction);
                }
                return;
            }
            this.forwardRequestThroughDialog(serverTransaction, clonedRequest, dialog);
        }
        catch (Exception ex) {
            try {
                if (this.proxy.getOutput() != null) {
                    this.proxy.getOutput().showError("RequestForwarding-forwardRequestStatefully: " + ex.getMessage());
                    Response response = messageFactory.createResponse(500, originalRequest);
                    if (serverTransaction != null) {
                        serverTransaction.sendResponse(response);
                    } else {
                        this.proxy.getSipProvider().sendResponse(response);
                    }
                    if (this.proxy.getOutput() != null) {
                        this.proxy.getOutput().showError("RequestForwarding-forwardRequestStatefully: 500 SERVER_INTERNAL_ERROR replied!" + response.toString());
                    }
                }
                ex.printStackTrace();
            }
            catch (Exception iex) {
                iex.printStackTrace();
            }
        }
    }

    private void forwardRequestThroughDialog(ServerTransaction serverTransaction, Request clonedRequest, Dialog dialog) throws Exception {
        TransactionsMapping transactionsMapping = (TransactionsMapping)serverTransaction.getDialog().getApplicationData();
        if (clonedRequest.getMethod().equals("CANCEL")) {
            Transaction firstTransaction = dialog.getFirstTransaction();
            if (firstTransaction == null) {
                throw new Exception("ERROR, RequestForwarding: the first transaction for the  dialog is null");
            }
            if (firstTransaction instanceof ClientTransaction) {
                if (this.proxy.getOutput() != null) {
                    this.proxy.getOutput().showMessage("CANCEL IGNORED");
                }
                return;
            }
            ServerTransaction firstServerTransaction = (ServerTransaction)firstTransaction;
            Vector clientTransactions = transactionsMapping.getClientTransactions(firstServerTransaction);
            if (clientTransactions == null) {
                throw new Exception("RequestForwarding: The peer first client transaction(s) for the first server transaction is null (CANCEL)");
            }
            if (clientTransactions.isEmpty()) {
                throw new Exception("RequestForwarding: The peer first client transaction(s) for the first server transaction is null (CANCEL)");
            }
            Enumeration e = clientTransactions.elements();
            while (e.hasMoreElements()) {
                ClientTransaction ct = (ClientTransaction)e.nextElement();
                if (ct.getState().equals(TransactionState.COMPLETED) || ct.getState().equals(TransactionState.TERMINATED)) continue;
                Request cancelRequest = ct.createCancel();
                ClientTransaction clientTransaction = this.proxy.getSipProvider().getNewClientTransaction(cancelRequest);
                clientTransaction.sendRequest();
                if (this.proxy.getOutput() == null) continue;
                this.proxy.getOutput().showMessage("RequestForwarding-forwardRequestThroughDialog: CANCEL sent statefully (using a new client transaction):\n " + cancelRequest);
            }
            return;
        }
        Dialog thisDialog = serverTransaction.getDialog();
        Dialog peerDialog = transactionsMapping.getPeerDialog(serverTransaction);
        if (peerDialog == null) {
            ClientTransaction clientTransaction = this.proxy.getSipProvider().getNewClientTransaction(clonedRequest);
            clientTransaction.sendRequest();
            transactionsMapping.addMapping(serverTransaction, clientTransaction);
            if (this.proxy.getOutput() != null) {
                this.proxy.getOutput().showMessage("RequestForwarding-forwardRequestThroughDialog: cloned request sent statefully using a new client transaction:\n " + clonedRequest);
            }
        } else if (clonedRequest.getMethod().equals("ACK")) {
            ClientTransaction clientTransaction = this.proxy.getSipProvider().getNewClientTransaction(clonedRequest);
            clientTransaction.sendRequest();
            if (this.proxy.getOutput() != null) {
                this.proxy.getOutput().showMessage("RequestForwarding-forwardRequestThroughDialog: Request sent statefully (using a new client transaction):\n " + clonedRequest);
            }
        } else {
            Request dialogRequest;
            block26: {
                ContentTypeHeader contentTypeHeader;
                dialogRequest = peerDialog.createRequest(clonedRequest.getMethod());
                Object content = clonedRequest.getContent();
                if (content != null && (contentTypeHeader = (ContentTypeHeader)clonedRequest.getHeader("Content-Type")) != null) {
                    dialogRequest.setContent(content, contentTypeHeader);
                }
                try {
                    ListIterator headerNames = clonedRequest.getHeaderNames();
                    while (headerNames.hasNext()) {
                        ListIterator routeHeaderIterator;
                        int k;
                        String name = (String)headerNames.next();
                        Header header = dialogRequest.getHeader(name);
                        if (header == null) {
                            ListIterator headerIterator = clonedRequest.getHeaders(name);
                            if (headerIterator == null) continue;
                            while (headerIterator.hasNext()) {
                                Header h = (Header)headerIterator.next();
                                dialogRequest.addHeader(h);
                            }
                            continue;
                        }
                        if (header instanceof ViaHeader) {
                            ListIterator viaHeaderIterator = clonedRequest.getHeaders(name);
                            if (viaHeaderIterator == null) continue;
                            dialogRequest.removeHeader(name);
                            Vector<Header> v = new Vector<Header>();
                            while (viaHeaderIterator.hasNext()) {
                                Header h = (Header)viaHeaderIterator.next();
                                v.addElement(h);
                            }
                            k = v.size() - 1;
                            while (k >= 0) {
                                Header h = (Header)v.elementAt(k);
                                dialogRequest.addHeader(h);
                                --k;
                            }
                            continue;
                        }
                        if (!(header instanceof RouteHeader) || (routeHeaderIterator = clonedRequest.getHeaders(name)) == null) continue;
                        dialogRequest.removeHeader(name);
                        Vector<RouteHeader> routes = new Vector<RouteHeader>();
                        while (routeHeaderIterator.hasNext()) {
                            RouteHeader routeHeader = (RouteHeader)routeHeaderIterator.next();
                            routes.addElement(routeHeader);
                        }
                        k = 0;
                        while (k < routes.size()) {
                            RouteHeader routeHeader = (RouteHeader)routes.elementAt(k);
                            dialogRequest.addHeader((Header)routeHeader);
                            ++k;
                        }
                    }
                }
                catch (Exception ex) {
                    if (this.proxy.getOutput() == null) break block26;
                    this.proxy.getOutput().showMessage("RequestForwarding-forwardRequestStatefully:  error trying to copy the headers from the original request");
                    ex.printStackTrace();
                }
            }
            if (this.proxy.getOutput() != null) {
                this.proxy.getOutput().showMessage("Forwarding request...");
            }
            ClientTransaction clientTransaction = this.proxy.getSipProvider().getNewClientTransaction(dialogRequest);
            clientTransaction.sendRequest();
            peerDialog.incrementLocalSequenceNumber();
            if (this.proxy.getOutput() != null) {
                this.proxy.getOutput().showMessage("RequestForwarding-forwardRequestThroughDialog: Request sent statefully (using a new client transaction):\n " + dialogRequest);
            }
            transactionsMapping.addMapping(serverTransaction, clientTransaction);
        }
    }

    private void forwardRequestStatelessly(Request clonedRequest, Request originalRequest, ServerTransaction serverTransaction) {
        MessageFactory messageFactory = this.proxy.getMessageFactory();
        HeaderFactory headerFactory = this.proxy.getHeaderFactory();
        AddressFactory addressFactory = this.proxy.getAddressFactory();
        SipStack sipStack = this.proxy.getSipStack();
        try {
            this.proxy.getSipProvider().sendRequest(clonedRequest);
            if (this.proxy.getOutput() != null) {
                this.proxy.getOutput().showMessage("RequestForwarding-forwardRequestStatelessly: cloned request forwarded statelessly:\n" + clonedRequest.toString());
            }
        }
        catch (Exception ex) {
            try {
                if (this.proxy.getOutput() != null) {
                    this.proxy.getOutput().showError("RequestForwarding-forwardRequestStatelessly internal error: " + ex.getMessage());
                }
                ex.printStackTrace();
                Response response = messageFactory.createResponse(500, originalRequest);
                if (serverTransaction != null) {
                    serverTransaction.sendResponse(response);
                } else {
                    this.proxy.getSipProvider().sendResponse(response);
                }
                if (this.proxy.getOutput() != null) {
                    this.proxy.getOutput().showError("RequestForwarding-forwardRequestStatelessly: 500 SERVER_INTERNAL_ERROR replied!" + response.toString());
                }
            }
            catch (Exception iex) {
                iex.printStackTrace();
            }
        }
    }
}

