/*
 * Decompiled with CFR 0.152.
 */
package hr.fer.teletk.sipas.proxy;

import hr.fer.teletk.sipas.proxy.Proxy;
import java.util.Iterator;
import java.util.ListIterator;
import javax.sip.ListeningPoint;
import javax.sip.ServerTransaction;
import javax.sip.SipStack;
import javax.sip.address.URI;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ProxyRequireHeader;
import javax.sip.header.UnsupportedHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;

public class RequestValidation {
    private Proxy proxy;

    public RequestValidation(Proxy proxy) {
        this.proxy = proxy;
    }

    public boolean validateRequest(Request request, ServerTransaction serverTransaction) {
        MessageFactory messageFactory = this.proxy.getMessageFactory();
        try {
            if (!this.checkURIScheme(request)) {
                Response response = messageFactory.createResponse(416, request);
                if (serverTransaction != null) {
                    serverTransaction.sendResponse(response);
                } else {
                    this.proxy.getSipProvider().sendResponse(response);
                }
                if (this.proxy.getOutput() != null) {
                    this.proxy.getOutput().showMessage("RequestValidation: 416 UNSUPPORTED_URI_SCHEME replied:\n" + response.toString());
                }
                return false;
            }
            if (!this.checkMaxForwards(request)) {
                Response response = messageFactory.createResponse(483, request);
                if (serverTransaction != null) {
                    serverTransaction.sendResponse(response);
                } else {
                    this.proxy.getSipProvider().sendResponse(response);
                }
                if (this.proxy.getOutput() != null) {
                    this.proxy.getOutput().showMessage("RequestValidation: 483 TOO_MANY_HOPS replied:\n" + response.toString());
                }
                return false;
            }
            if (!this.checkLoopDetection(request)) {
                Response response = messageFactory.createResponse(482, request);
                if (serverTransaction != null) {
                    serverTransaction.sendResponse(response);
                } else {
                    this.proxy.getSipProvider().sendResponse(response);
                }
                if (this.proxy.getOutput() != null) {
                    this.proxy.getOutput().showMessage("RequestValidation: 482 LOOP_DETECTED replied:\n" + response.toString());
                }
                return false;
            }
            if (!this.checkProxyRequire(request)) {
                Response response = messageFactory.createResponse(420, request);
                HeaderFactory headerFactory = this.proxy.getHeaderFactory();
                ProxyRequireHeader prh = (ProxyRequireHeader)request.getHeader("Proxy-Require");
                if (prh != null) {
                    UnsupportedHeader unsupportedHeader = headerFactory.createUnsupportedHeader(prh.getOptionTag());
                    response.setHeader((Header)unsupportedHeader);
                }
                if (serverTransaction != null) {
                    serverTransaction.sendResponse(response);
                } else {
                    this.proxy.getSipProvider().sendResponse(response);
                }
                if (this.proxy.getOutput() != null) {
                    this.proxy.getOutput().showMessage("\nRequestValidation: 420 BAD_EXTENSION replied:\n" + response.toString());
                }
                return false;
            }
            if (!this.checkFromTag(request)) {
                Response response = messageFactory.createResponse(400, request);
                if (serverTransaction != null) {
                    serverTransaction.sendResponse(response);
                } else {
                    this.proxy.getSipProvider().sendResponse(response);
                }
                if (this.proxy.getOutput() != null) {
                    this.proxy.getOutput().showMessage("RequestValidation: 400 BAD_REQUEST replied:\n" + response.toString());
                }
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (this.proxy.getOutput() != null) {
                this.proxy.getOutput().showError("RequestValidation: Error validating request!");
            }
            return false;
        }
    }

    private boolean checkFromTag(Request request) {
        try {
            FromHeader fromHeader = (FromHeader)request.getHeader("From");
            return fromHeader.getTag() != null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (this.proxy.getOutput() != null) {
                this.proxy.getOutput().showError("RequestValidation: Request's from tag invalid!");
            }
            return false;
        }
    }

    private boolean checkLoopDetection(Request request) {
        try {
            SipStack sipStack = this.proxy.getSipStack();
            ListIterator viaList = request.getHeaders("Via");
            if (viaList == null) {
                return false;
            }
            String stackIPAddress = sipStack.getIPAddress();
            while (viaList.hasNext()) {
                ViaHeader viaHeader = (ViaHeader)viaList.next();
                String host = viaHeader.getHost();
                if (!host.equals(stackIPAddress)) continue;
                Iterator lps = sipStack.getListeningPoints();
                while (lps != null && lps.hasNext()) {
                    ListeningPoint lp = (ListeningPoint)lps.next();
                    int port = lp.getPort();
                    if (viaHeader.getPort() != port) continue;
                    if (this.proxy.getOutput() != null) {
                        this.proxy.getOutput().showError("RequestValidation, checkLoopDetection(), the via port matches the proxy port!");
                    }
                    return false;
                }
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (this.proxy.getOutput() != null) {
                this.proxy.getOutput().showError("RequestValidation: the request has looped!");
            }
            return false;
        }
    }

    private boolean checkMaxForwards(Request request) {
        try {
            HeaderFactory headerFactory = this.proxy.getHeaderFactory();
            MessageFactory messageFactory = this.proxy.getMessageFactory();
            MaxForwardsHeader mf = (MaxForwardsHeader)request.getHeader("Max-Forwards");
            if (mf == null) {
                return true;
            }
            return mf.getMaxForwards() != 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (this.proxy.getOutput() != null) {
                this.proxy.getOutput().showError("RequestValidation: Error checking MaxForwards!");
            }
            return false;
        }
    }

    private boolean checkProxyAuthorization(Request request) {
        return true;
    }

    private boolean checkProxyRequire(Request request) {
        try {
            ProxyRequireHeader prh = (ProxyRequireHeader)request.getHeader("Proxy-Require");
            if (prh == null) {
                return true;
            }
            String optionTag = prh.getOptionTag();
            return optionTag.compareTo("100rel") == 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (this.proxy.getOutput() != null) {
                this.proxy.getOutput().showError("RequestValidation: Error validating Proxy-Require!");
            }
            return false;
        }
    }

    private boolean checkURIScheme(Request request) {
        try {
            URI requestURI = request.getRequestURI();
            String uriScheme = requestURI.getScheme();
            return uriScheme.equals("sip");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (this.proxy.getOutput() != null) {
                this.proxy.getOutput().showError("RequestValidation: Error checking URI scheme!");
            }
            return false;
        }
    }
}

