/*
 * Decompiled with CFR 0.152.
 */
package hr.fer.teletk.sipas.proxy;

import hr.fer.teletk.sipas.matching.SipAsQnc;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.ServerTransaction;
import javax.sip.Transaction;

public class TransactionsMapping {
    private Hashtable mapping = new Hashtable();
    private SipAsQnc sipAsQnc;
    public static final int SESSION_ESTABLISHING = 0;
    public static final int IDLE = 1;
    public static final int CHANGING_SERVICE = 2;
    public static final int STREAMING = 3;
    public static final int CHANGING_RESOURCE = 4;
    public static final int NEW_STREAMING = 5;
    public static final int NEW_SESSION_ESTABLISHING = 6;
    public static final int NEW_SCENE_DOWNLOADING = 7;
    private int state = 0;

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    protected TransactionsMapping(ServerTransaction serverTransaction) {
        Dialog serverDialog = serverTransaction.getDialog();
        serverDialog.setApplicationData((Object)this);
    }

    protected void addMapping(ServerTransaction serverTransaction, ClientTransaction clientTransaction) {
        if (clientTransaction == null) {
            return;
        }
        if (clientTransaction.getDialog() == null) {
            return;
        }
        Vector<ClientTransaction> clientTransactions = this.getClientTransactions(serverTransaction);
        Dialog serverDialog = serverTransaction.getDialog();
        TransactionsMapping map = (TransactionsMapping)serverDialog.getApplicationData();
        Dialog clientDialog = clientTransaction.getDialog();
        clientDialog.setApplicationData((Object)map);
        if (clientTransactions == null) {
            clientTransactions = new Vector<ClientTransaction>();
            this.mapping.put(serverTransaction, clientTransactions);
            clientTransactions.addElement(clientTransaction);
        } else {
            Enumeration e = clientTransactions.elements();
            while (e.hasMoreElements()) {
                if (clientTransaction != e.nextElement()) continue;
                return;
            }
            clientTransactions.addElement(clientTransaction);
        }
    }

    protected ClientTransaction getClientTransaction(ServerTransaction serverTransaction) {
        Vector vector = (Vector)this.mapping.get(serverTransaction);
        if (vector == null) {
            return null;
        }
        Enumeration e = vector.elements();
        while (e.hasMoreElements()) {
            ClientTransaction ct = (ClientTransaction)e.nextElement();
            Dialog d = ct.getDialog();
            if (d.getState() == null) continue;
            return ct;
        }
        return null;
    }

    protected Vector getClientTransactions(ServerTransaction serverTransaction) {
        if (serverTransaction == null) {
            return null;
        }
        return (Vector)this.mapping.get(serverTransaction);
    }

    protected ServerTransaction getServerTransaction(ClientTransaction clientTransaction) {
        Enumeration e = this.mapping.keys();
        while (e.hasMoreElements()) {
            ServerTransaction serverTransaction = (ServerTransaction)e.nextElement();
            Vector vector = (Vector)this.mapping.get(serverTransaction);
            Enumeration en = vector.elements();
            while (en.hasMoreElements()) {
                ClientTransaction ct = (ClientTransaction)en.nextElement();
                if (ct != clientTransaction) continue;
                return serverTransaction;
            }
        }
        return null;
    }

    protected Dialog getPeerDialog(ServerTransaction serverTransaction) {
        if (this.mapping.containsKey(serverTransaction)) {
            ClientTransaction ct = this.getClientTransaction(serverTransaction);
            if (ct != null) {
                return ct.getDialog();
            }
        } else {
            Transaction transaction = serverTransaction.getDialog().getFirstTransaction();
            if (transaction instanceof ServerTransaction) {
                ClientTransaction ct = this.getClientTransaction((ServerTransaction)transaction);
                if (ct != null) {
                    return ct.getDialog();
                }
            } else {
                ServerTransaction st = this.getServerTransaction((ClientTransaction)transaction);
                if (st != null) {
                    return st.getDialog();
                }
            }
        }
        return null;
    }

    protected void removeMapping(ClientTransaction clientTransaction) {
        ServerTransaction serverTransaction = this.getServerTransaction(clientTransaction);
        Vector clientTransactions = this.getClientTransactions(serverTransaction);
        if (clientTransactions != null && clientTransactions.isEmpty()) {
            clientTransactions.removeElement(clientTransaction);
            this.mapping.remove(serverTransaction);
        }
    }

    protected void removeMapping(ServerTransaction serverTransaction) {
        this.mapping.remove(serverTransaction);
    }

    protected boolean hasMapping(ServerTransaction st) {
        if (!this.mapping.containsKey(st)) {
            return false;
        }
        Vector vector = (Vector)this.mapping.get(st);
        return !vector.isEmpty();
    }

    public void setSipAsQnc(SipAsQnc sipAsQnc) {
        this.sipAsQnc = sipAsQnc;
    }

    public SipAsQnc getSipAsQnc() {
        return this.sipAsQnc;
    }
}

