/*
 * Decompiled with CFR 0.152.
 */
package hr.fer.teletk.sipas.proxy.gui;

import hr.fer.teletk.sipas.proxy.gui.ConfigurationTableModel;
import hr.fer.teletk.sipas.proxy.gui.SipASLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class SipASConfigurationDialog
extends JDialog {
    private JPanel jContentPane = null;
    private JTable configurationTable = null;
    private JScrollPane tableScrollPane = null;
    private SipASLauncher launcher;
    private ConfigurationTableModel configurationTableModel = null;
    private JPanel buttonsPane = null;
    private JButton saveButton = null;
    private JButton cancelButton = null;

    public SipASConfigurationDialog(SipASLauncher launcher, boolean modal) {
        this.launcher = launcher;
        this.setModal(modal);
        this.initialize();
    }

    private void initialize() {
        this.setTitle("DSAM SIP Application Server Configuration");
        this.setSize(390, 240);
        this.setContentPane(this.getJContentPane());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SipASConfigurationDialog.this.dispose();
                if (!SipASConfigurationDialog.this.launcher.isVisible()) {
                    System.exit(0);
                }
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getTableScrollPane(), "Center");
            this.jContentPane.add((Component)this.getButtonsPane(), "South");
        }
        return this.jContentPane;
    }

    private JTable getConfigurationTable() {
        if (this.configurationTable == null) {
            this.configurationTable = new JTable();
            this.configurationTable.setModel(this.getConfigurationTableModel());
            this.configurationTable.setPreferredScrollableViewportSize(new Dimension(600, 600));
            this.configurationTable.setPreferredSize(new Dimension(600, 600));
            TableColumn firstColumn = this.configurationTable.getColumnModel().getColumn(0);
            TableColumn secondColumn = this.configurationTable.getColumnModel().getColumn(1);
            firstColumn.setPreferredWidth(200);
            secondColumn.setPreferredWidth(20);
        }
        return this.configurationTable;
    }

    private JScrollPane getTableScrollPane() {
        if (this.tableScrollPane == null) {
            this.tableScrollPane = new JScrollPane();
            this.tableScrollPane.setViewportView(this.getConfigurationTable());
        }
        return this.tableScrollPane;
    }

    private ConfigurationTableModel getConfigurationTableModel() {
        if (this.configurationTableModel == null) {
            this.configurationTableModel = new ConfigurationTableModel(this.launcher.configurationHandler, this);
        }
        return this.configurationTableModel;
    }

    private JPanel getButtonsPane() {
        if (this.buttonsPane == null) {
            this.buttonsPane = new JPanel();
            this.buttonsPane.add((Component)this.getSaveButton(), null);
            this.buttonsPane.add((Component)this.getCancelButton(), null);
        }
        return this.buttonsPane;
    }

    private JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton();
            this.saveButton.setText("Save");
            this.saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        ((SipASConfigurationDialog)SipASConfigurationDialog.this).getConfigurationTableModel().configurationHandler.commit();
                        SipASConfigurationDialog.this.dispose();
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(SipASConfigurationDialog.this, ioe.getMessage(), "Error Saving Configuration", 0);
                    }
                    catch (RuntimeException re) {
                        JOptionPane.showMessageDialog(SipASConfigurationDialog.this, re.getMessage(), "Missing propertie value", 2);
                    }
                }
            });
        }
        return this.saveButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SipASConfigurationDialog.this.dispose();
                    if (!SipASConfigurationDialog.this.launcher.isVisible()) {
                        System.exit(0);
                    }
                }
            });
        }
        return this.cancelButton;
    }

    protected void invalidDataChange(String message) {
        JOptionPane.showMessageDialog(this, message, "Invalid configuration argument", 2);
    }
}

