/*
 * Decompiled with CFR 0.152.
 */
package hr.fer.teletk.sipas.proxy.gui;

import hr.fer.teletk.sipas.proxy.ConfigurationHandler;
import hr.fer.teletk.sipas.proxy.Proxy;
import hr.fer.teletk.sipas.proxy.ProxyOutput;
import hr.fer.teletk.sipas.proxy.gui.SipASAboutBoxDialog;
import hr.fer.teletk.sipas.proxy.gui.SipASConfigurationDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;

public class SipASLauncher
extends JFrame
implements ProxyOutput {
    private final String CONFIGURATION_FILE = "configuration.properties";
    protected ConfigurationHandler configurationHandler;
    private Proxy proxy;
    private JPanel jContentPane = null;
    private JMenuBar jJMenuBar = null;
    private JMenu File = null;
    private JMenu helpMenu = null;
    private JMenuItem exitMenuItem = null;
    private JMenuItem aboutMenuItem = null;
    private JMenuItem configurationMenuItem = null;
    private JPanel statusTitlePanel = null;
    private JPanel buttonsPanel = null;
    private JPanel statusMessagesPanel = null;
    private JScrollPane statusMessagesScrollPane = null;
    private JTextArea statusMessagesTextArea = null;
    private JButton startSipASButton = null;
    private JButton stopSipASButton = null;
    private JLabel statusLabel = null;

    private JPanel getStatusTitlePanel() {
        if (this.statusTitlePanel == null) {
            this.statusLabel = new JLabel();
            this.statusTitlePanel = new JPanel();
            this.statusLabel.setText("Current Status");
            this.statusTitlePanel.add((Component)this.statusLabel, null);
        }
        return this.statusTitlePanel;
    }

    private JPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.add((Component)this.getStartSipASButton(), null);
            this.buttonsPanel.add((Component)this.getStopSipASButton(), null);
        }
        return this.buttonsPanel;
    }

    private JPanel getStatusMessagesPanel() {
        if (this.statusMessagesPanel == null) {
            this.statusMessagesPanel = new JPanel();
            this.statusMessagesPanel.add((Component)this.getStatusMessagesScrollPane(), null);
        }
        return this.statusMessagesPanel;
    }

    private JScrollPane getStatusMessagesScrollPane() {
        if (this.statusMessagesScrollPane == null) {
            this.statusMessagesScrollPane = new JScrollPane();
            this.statusMessagesScrollPane.setViewportView(this.getStatusMessagesTextArea());
            this.statusMessagesScrollPane.setPreferredSize(new Dimension(350, 250));
        }
        return this.statusMessagesScrollPane;
    }

    private JTextArea getStatusMessagesTextArea() {
        if (this.statusMessagesTextArea == null) {
            this.statusMessagesTextArea = new JTextArea();
            this.statusMessagesTextArea.setLineWrap(true);
            this.statusMessagesTextArea.setEditable(false);
        }
        return this.statusMessagesTextArea;
    }

    private JButton getStartSipASButton() {
        if (this.startSipASButton == null) {
            this.startSipASButton = new JButton();
            this.startSipASButton.setText("Start SIP AS");
            this.startSipASButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SipASLauncher.this.proxy != null) {
                        SipASLauncher.this.startSipASButton.setEnabled(false);
                        SipASLauncher.this.getStopSipASButton().setEnabled(true);
                        try {
                            SipASLauncher.this.proxy.start();
                        }
                        catch (Exception ex) {
                            SipASLauncher.this.startSipASButton.setEnabled(true);
                            SipASLauncher.this.getStopSipASButton().setEnabled(false);
                            JOptionPane.showMessageDialog(SipASLauncher.this, "Unable to start!\n" + ex.getMessage(), "Error Starting", 0);
                        }
                    } else {
                        JOptionPane.showMessageDialog(SipASLauncher.this, "Unable to start! Proxy not initialized!", "Error Starting", 0);
                    }
                }
            });
        }
        return this.startSipASButton;
    }

    private JButton getStopSipASButton() {
        if (this.stopSipASButton == null) {
            this.stopSipASButton = new JButton();
            this.stopSipASButton.setText("Stop SIP AS");
            this.stopSipASButton.setEnabled(false);
            this.stopSipASButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SipASLauncher.this.proxy != null) {
                        SipASLauncher.this.stopSipASButton.setEnabled(false);
                        SipASLauncher.this.getStartSipASButton().setEnabled(true);
                        try {
                            SipASLauncher.this.proxy.stop();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            JOptionPane.showMessageDialog(SipASLauncher.this, ex.getMessage(), "Error Stopping", 0);
                        }
                    } else {
                        JOptionPane.showMessageDialog(SipASLauncher.this, "Unable to stop! Proxy not initialized!", "Error Stopping", 0);
                    }
                }
            });
        }
        return this.stopSipASButton;
    }

    public static void main(String[] args) {
        SipASLauncher sipASLauncher = new SipASLauncher();
        sipASLauncher.validate();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = sipASLauncher.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        sipASLauncher.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        sipASLauncher.setVisible(true);
    }

    public SipASLauncher() {
        this.initialize();
        this.configurationHandler = new ConfigurationHandler("configuration.properties");
        try {
            this.configurationHandler.init();
        }
        catch (IOException ioe) {
            int choice = JOptionPane.showConfirmDialog(this, "Could not find or read from the configuration file!\nWould you like to create a new one?", "Error reading the configuration", 0, 2);
            if (choice == 0) {
                this.getConfigurationMenuItem().doClick();
            } else {
                System.exit(-1);
            }
        }
        catch (IllegalArgumentException iae) {
            JOptionPane.showMessageDialog(this, iae.getMessage(), "Invalid configuration argument", 2);
            this.getConfigurationMenuItem().doClick();
        }
        try {
            this.proxy = new Proxy(this.configurationHandler, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initialize() {
        this.setDefaultCloseOperation(3);
        this.setJMenuBar(this.getJJMenuBar());
        this.setSize(423, 400);
        this.setContentPane(this.getJContentPane());
        this.setTitle("DSAM SIP Aplication Server");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getStatusTitlePanel(), "North");
            this.jContentPane.add((Component)this.getButtonsPanel(), "South");
            this.jContentPane.add((Component)this.getStatusMessagesPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getFile());
            this.jJMenuBar.add(this.getHelpMenu());
        }
        return this.jJMenuBar;
    }

    private JMenu getFile() {
        if (this.File == null) {
            this.File = new JMenu();
            this.File.setText("File");
            this.File.add(this.getConfigurationMenuItem());
            this.File.add(this.getExitMenuItem());
        }
        return this.File;
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText("Help");
            this.helpMenu.add(this.getAboutMenuItem());
        }
        return this.helpMenu;
    }

    private JMenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new JMenuItem();
            this.exitMenuItem.setText("Exit");
            this.exitMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
        }
        return this.exitMenuItem;
    }

    private JMenuItem getAboutMenuItem() {
        if (this.aboutMenuItem == null) {
            this.aboutMenuItem = new JMenuItem();
            this.aboutMenuItem.setText("About");
            this.aboutMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Point location = SipASLauncher.this.getLocation();
                    Dimension frameSize = SipASLauncher.this.getSize();
                    SipASAboutBoxDialog aboutDialog = new SipASAboutBoxDialog(SipASLauncher.this, true);
                    Dimension aboutDialogSize = aboutDialog.getPreferredSize();
                    aboutDialog.setLocation((frameSize.width - aboutDialogSize.width) / 2 + location.x, (frameSize.height - aboutDialogSize.height) / 2 + location.y);
                    aboutDialog.setVisible(true);
                }
            });
        }
        return this.aboutMenuItem;
    }

    private JMenuItem getConfigurationMenuItem() {
        if (this.configurationMenuItem == null) {
            this.configurationMenuItem = new JMenuItem();
            this.configurationMenuItem.setText("Configuration");
            this.configurationMenuItem.setActionCommand("Configuration");
            this.configurationMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SipASConfigurationDialog configurationDialog = new SipASConfigurationDialog(SipASLauncher.this, true);
                    Dimension configurationDialogSize = configurationDialog.getPreferredSize();
                    if (SipASLauncher.this.isVisible()) {
                        Point location = SipASLauncher.this.getLocation();
                        Dimension frameSize = SipASLauncher.this.getSize();
                        configurationDialog.setLocation((frameSize.width - configurationDialogSize.width) / 2 + location.x, (frameSize.height - configurationDialogSize.height) / 2 + location.y);
                    } else {
                        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                        Dimension dialogSize = configurationDialog.getSize();
                        if (dialogSize.height > screenSize.height) {
                            dialogSize.height = screenSize.height;
                        }
                        if (dialogSize.width > screenSize.width) {
                            dialogSize.width = screenSize.width;
                        }
                        configurationDialog.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
                    }
                    configurationDialog.setVisible(true);
                }
            });
        }
        return this.configurationMenuItem;
    }

    public void showError(String error) {
        int appendedTextStart = this.getStatusMessagesTextArea().getText().length();
        int appendedTextEnd = appendedTextStart + error.length();
        this.getStatusMessagesTextArea().append("\n" + error);
        this.getStatusMessagesTextArea().setSelectionStart(appendedTextStart);
        this.getStatusMessagesTextArea().setSelectionEnd(appendedTextEnd);
        this.getStatusMessagesTextArea().setSelectionColor(Color.RED);
        int size = this.getStatusMessagesTextArea().getText().length();
        try {
            Rectangle view = this.getStatusMessagesTextArea().modelToView(size);
            this.getStatusMessagesScrollPane().getViewport().setViewPosition(view.getLocation());
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        this.getStatusMessagesScrollPane().validate();
    }

    public void showMessage(String message) {
        this.getStatusMessagesTextArea().setForeground(Color.BLACK);
        this.getStatusMessagesTextArea().append("\n" + message);
        int size = this.getStatusMessagesTextArea().getText().length();
        try {
            Rectangle view = this.getStatusMessagesTextArea().modelToView(size);
            this.getStatusMessagesScrollPane().getViewport().setViewPosition(view.getLocation());
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        this.getStatusMessagesScrollPane().validate();
    }
}

