/*
 * Decompiled with CFR 0.152.
 */
package hr.fer.tel.nims.dsa.client.sipAgent;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.sip.InvalidArgumentException;
import javax.sip.address.Hop;

public class HopImpl
implements Hop {
    private String host;
    private int port;
    private String transport;
    public static final String UDP = "UDP";
    public static final String TCP = "TCP";

    public HopImpl(String hop) throws InvalidArgumentException {
        String portandtrans = null;
        boolean portSpecified = false;
        if (hop == null) {
            throw new InvalidArgumentException("Hop mustn't be null");
        }
        if (hop.equals("")) {
            throw new InvalidArgumentException("Hop mustn't be empty");
        }
        if (hop.indexOf(91) != -1) {
            if (hop.indexOf(93) == -1 || hop.indexOf(91) != 0) {
                throw new InvalidArgumentException("Invalid format for IPv6 address!");
            }
            this.host = hop.substring(0, hop.indexOf(93) + 1);
            if (hop.length() > hop.indexOf(93) + 1) {
                portandtrans = hop.substring(hop.indexOf(93) + 1, hop.length());
                if (portandtrans.indexOf(58) != -1) {
                    portandtrans = portandtrans.substring(portandtrans.indexOf(58) + 1, portandtrans.length());
                    StringTokenizer tokenizer = new StringTokenizer(portandtrans, "/");
                    try {
                        this.port = Integer.valueOf(tokenizer.nextToken());
                    }
                    catch (NumberFormatException nfe) {
                        throw new InvalidArgumentException("Port number is invalid");
                    }
                    try {
                        this.transport = tokenizer.nextToken();
                    }
                    catch (NoSuchElementException nsee) {
                        this.transport = UDP;
                    }
                } else {
                    this.port = 5060;
                    this.transport = portandtrans.substring(1, portandtrans.length());
                }
            } else {
                this.port = 5060;
                this.transport = UDP;
            }
        } else if (hop.indexOf(58) == hop.lastIndexOf(58)) {
            StringTokenizer tokenizer = new StringTokenizer(hop, ":");
            try {
                this.host = tokenizer.nextToken();
            }
            catch (NoSuchElementException nsee) {
                throw new InvalidArgumentException("Hop mustn't be \":\"");
            }
            try {
                portandtrans = tokenizer.nextToken();
                portSpecified = true;
            }
            catch (NoSuchElementException nsee) {
                this.port = 5060;
            }
            if (!portSpecified) {
                tokenizer = new StringTokenizer(this.host, "/");
                this.host = tokenizer.nextToken();
                try {
                    this.transport = tokenizer.nextToken();
                }
                catch (NoSuchElementException nsee) {
                    this.transport = UDP;
                }
            } else {
                tokenizer = new StringTokenizer(portandtrans, "/");
                try {
                    this.port = Integer.valueOf(tokenizer.nextToken());
                }
                catch (NumberFormatException nfe) {
                    throw new InvalidArgumentException("Port number is invalid");
                }
                try {
                    this.transport = tokenizer.nextToken();
                }
                catch (NoSuchElementException nsee) {
                    this.transport = UDP;
                }
            }
        } else {
            this.port = 5060;
            StringTokenizer tokenizer = new StringTokenizer(hop, "/");
            this.host = String.valueOf('[') + tokenizer.nextToken() + ']';
            try {
                this.transport = tokenizer.nextToken();
            }
            catch (NoSuchElementException nsee) {
                this.transport = UDP;
            }
        }
        if (this.port < 1024 || this.port > 65536) {
            throw new InvalidArgumentException("Port number out of range");
        }
        if (!this.transport.equalsIgnoreCase(UDP) && !this.transport.equalsIgnoreCase(TCP)) {
            throw new InvalidArgumentException("Transport not suppported");
        }
    }

    public HopImpl(String host, int port, String transport) throws InvalidArgumentException {
        this.host = host;
        this.port = port;
        this.transport = transport;
        if (port < 1024 || port > 65536) {
            throw new InvalidArgumentException("Port number out of range");
        }
        if (!transport.equalsIgnoreCase(UDP) && !transport.equalsIgnoreCase(TCP)) {
            throw new InvalidArgumentException("Transport not suppported");
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getTransport() {
        return this.transport;
    }
}

