/*
 * Decompiled with CFR 0.152.
 */
package hr.fer.tel.nims.dsa.client.sipAgent;

import gov.nist.javax.sip.Utils;
import hr.fer.tel.nims.dsa.client.ConfigurationHandler;
import hr.fer.tel.nims.dsa.client.sipAgent.SIPUserAgentServer;
import hr.fer.tel.nims.dsa.client.sipAgent.SessionData;
import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.TooManyListenersException;
import java.util.Vector;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.PeerUnavailableException;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.Transaction;
import javax.sip.TransactionDoesNotExistException;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.AllowHeader;
import javax.sip.header.AuthorizationHeader;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentLengthHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.RAckHeader;
import javax.sip.header.RSeqHeader;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.RequireHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.header.WWWAuthenticateHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.swing.JOptionPane;

public class SIPUserAgent {
    boolean packFrame = false;
    private SipProvider sipProvider;
    private SipStack sipStack;
    private AddressFactory addressFactory;
    private HeaderFactory headerFactory;
    private MessageFactory messageFactory;
    private SIPUserAgentServer sipUserAgentServer;
    private String domain = null;
    private SessionData sessionData;
    private String sessionDescription;
    private String localUserName;
    private String localUserDisplayName;
    private String serviceSIPURI;
    private static final char[] toHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private ConfigurationHandler configurationHandler;

    public SIPUserAgent(int portNumber, String configurationFile) throws FileNotFoundException, IOException, NullPointerException {
        this.configurationHandler = new ConfigurationHandler(configurationFile);
        this.configurationHandler.init();
    }

    public void start() throws PeerUnavailableException, SipException, ObjectInUseException {
        SipFactory sipFactory = SipFactory.getInstance();
        sipFactory.setPathName("gov.nist");
        this.addressFactory = sipFactory.createAddressFactory();
        this.headerFactory = sipFactory.createHeaderFactory();
        this.messageFactory = sipFactory.createMessageFactory();
        if (this.configurationHandler.getConfigurationProperties() == null) {
            throw new SipException("Stack configuration not loaded or invalid!");
        }
        this.sipStack = sipFactory.createSipStack(this.configurationHandler.getConfigurationProperties());
        ListeningPoint listeningPoint = null;
        try {
            int port = this.configurationHandler.getTransportPort();
            System.out.println("Port je " + port);
            String transport = this.configurationHandler.getTransportProtocol();
            System.out.println("Transport je " + transport);
            if (port == 0 || transport == null) {
                throw new SipException("Stack configuration not loaded or invalid!");
            }
            listeningPoint = this.sipStack.createListeningPoint(port, transport);
            this.sipProvider = this.sipStack.createSipProvider(listeningPoint);
        }
        catch (NullPointerException npe) {
            throw new SipException("Couldn't get listening point!");
        }
        catch (ObjectInUseException oiue) {
            throw oiue;
        }
        catch (InvalidArgumentException iae) {
            throw new SipException("Stack configuration not loaded or invalid!");
        }
        try {
            this.sipProvider.addSipListener((SipListener)this.sipUserAgentServer);
        }
        catch (TooManyListenersException e) {
            throw new SipException("Error registering SipListener - SipListener already registered!");
        }
    }

    public void register(String userName, String serviceSIPURI, String domain) throws InvalidArgumentException, ParseException, SipException {
        System.out.println("pocetak...");
        this.domain = domain;
        try {
            String transport = this.sipProvider.getListeningPoint().getTransport();
            ViaHeader viaHeader = this.headerFactory.createViaHeader(this.sipStack.getIPAddress(), this.sipProvider.getListeningPoint().getPort(), transport, Utils.generateBranchId());
            SipURI toURI = this.addressFactory.createSipURI(userName, domain);
            Address toAddress = this.addressFactory.createAddress(userName, (URI)toURI);
            ToHeader toHeader = this.headerFactory.createToHeader(toAddress, null);
            SipURI fromSipURI = this.addressFactory.createSipURI(userName, domain);
            Address fromAddress = this.addressFactory.createAddress(userName, (URI)fromSipURI);
            FromHeader fromHeader = this.headerFactory.createFromHeader(fromAddress, Utils.generateTag());
            CallIdHeader callIdHeader = this.sipProvider.getNewCallId();
            CSeqHeader cSeqHeader = this.headerFactory.createCSeqHeader(1, "REGISTER");
            ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
            viaHeaders.add(viaHeader);
            SipURI registerURI = this.addressFactory.createSipURI(null, domain);
            Request register = this.messageFactory.createRequest((URI)registerURI, "REGISTER", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, this.headerFactory.createMaxForwardsHeader(70));
            ClientTransaction clientTransaction = this.sipProvider.getNewClientTransaction(register);
            clientTransaction.sendRequest();
            System.out.println("Sent message: ");
            System.out.println(register.toString());
            System.out.println("+++++++++++++++++++++++");
        }
        catch (NullPointerException npe) {
            throw npe;
        }
        catch (InvalidArgumentException iae) {
            throw iae;
        }
        catch (ParseException pe) {
            throw pe;
        }
        catch (ClassCastException cce) {
            throw cce;
        }
    }

    public void registerWithPassword(String name, String password, ResponseEvent responseEvent) throws InvalidArgumentException, ParseException {
        Response response = responseEvent.getResponse();
        try {
            String transport = this.sipProvider.getListeningPoint().getTransport();
            ViaHeader viaHeader = this.headerFactory.createViaHeader(this.sipStack.getIPAddress(), this.sipProvider.getListeningPoint().getPort(), transport, Utils.generateBranchId());
            SipURI toURI = this.addressFactory.createSipURI(name, this.domain);
            Address toAddress = this.addressFactory.createAddress(name, (URI)toURI);
            ToHeader toHeader = this.headerFactory.createToHeader(toAddress, null);
            Address address = toHeader.getAddress();
            SipURI URI2 = (SipURI)address.getURI();
            String uri = URI2.getHost();
            String user = URI2.getUser();
            String userName = String.valueOf(user) + "@" + uri;
            FromHeader fromHeader = (FromHeader)response.getHeader("From");
            fromHeader.setTag(Utils.generateTag());
            CallIdHeader callIdHeader = this.sipProvider.getNewCallId();
            WWWAuthenticateHeader www = (WWWAuthenticateHeader)response.getHeader("WWW-Authenticate");
            CSeqHeader cseq = (CSeqHeader)response.getHeader("CSeq");
            CSeqHeader cSeqHeader = this.headerFactory.createCSeqHeader(cseq.getSequenceNumber() + 1, "REGISTER");
            ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
            viaHeaders.add(viaHeader);
            SipURI registerURI = this.addressFactory.createSipURI(null, this.domain);
            Request register = this.messageFactory.createRequest((URI)registerURI, "REGISTER", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, this.headerFactory.createMaxForwardsHeader(70));
            SipURI contactURI = this.addressFactory.createSipURI(this.localUserName, this.sipStack.getIPAddress());
            contactURI.setPort(this.sipProvider.getListeningPoint().getPort());
            Address contactAddress = this.addressFactory.createAddress(this.localUserName, (URI)contactURI);
            ContactHeader contactHeader = this.headerFactory.createContactHeader(contactAddress);
            contactHeader.setExpires(3600);
            register.addHeader((Header)contactHeader);
            String A1 = String.valueOf(userName) + ":" + www.getRealm() + ":" + password;
            String A2 = "REGISTER:sip:research.local";
            String HA1 = this.getMessageDigest(A1, "MD5", "ASCII");
            String HA2 = this.getMessageDigest(A2, "MD5", "ASCII");
            String D = String.valueOf(HA1) + ":" + www.getNonce() + ":" + "00000001" + ":" + "5af16df1" + ":" + www.getQop() + ":" + HA2;
            String KD = this.getMessageDigest(D, "MD5", "ASCII");
            int nonceCount = 1;
            AuthorizationHeader autHeader = this.headerFactory.createAuthorizationHeader(www.getScheme());
            autHeader.setUsername(userName);
            autHeader.setRealm(www.getRealm());
            autHeader.setNonce(www.getNonce());
            autHeader.setAlgorithm(www.getAlgorithm());
            autHeader.setCNonce("5af16df1");
            autHeader.setOpaque(www.getOpaque());
            autHeader.setURI((URI)registerURI);
            autHeader.setResponse(KD);
            autHeader.setQop(www.getQop());
            autHeader.setNonceCount(nonceCount);
            register.addHeader((Header)autHeader);
            ClientTransaction clientTransaction = this.sipProvider.getNewClientTransaction(register);
            clientTransaction.sendRequest();
            System.out.println("Sent message: ");
            System.out.println(register.toString());
            System.out.println("+++++++++++++++++++++++");
        }
        catch (NullPointerException npe) {
            throw npe;
        }
        catch (InvalidArgumentException iae) {
            throw iae;
        }
        catch (ParseException pe) {
            throw pe;
        }
        catch (ClassCastException cce) {
            throw cce;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (SipException e) {
            e.printStackTrace();
        }
    }

    protected boolean setUser(String localUserName, String localUserDisplayName) {
        if (this.sessionData == null) {
            this.localUserName = localUserName;
            this.localUserDisplayName = localUserDisplayName;
            return true;
        }
        return false;
    }

    protected String getUser() {
        return this.localUserName;
    }

    public void placeCall(String sipURI, String user, String displayName) throws NullPointerException, InvalidArgumentException, ParseException, SipException, ClassCastException {
        if (this.serviceSIPURI == null) {
            this.serviceSIPURI = sipURI;
        }
        SipURI fromSipURI = this.addressFactory.createSipURI(user, this.sipStack.getIPAddress());
        fromSipURI.setPort(this.sipProvider.getListeningPoint().getPort());
        Address fromAddress = this.addressFactory.createAddress(displayName, (URI)fromSipURI);
        FromHeader fromHeader = this.headerFactory.createFromHeader(fromAddress, Utils.generateTag());
        SipURI toURI = (SipURI)this.addressFactory.createURI(this.serviceSIPURI);
        Address toAddress = this.addressFactory.createAddress((URI)toURI);
        ToHeader toHeader = this.headerFactory.createToHeader(toAddress, null);
        SipURI requestURI = (SipURI)toURI.clone();
        requestURI.setTransportParam("TCP");
        String transport = this.sipProvider.getListeningPoint().getTransport();
        ViaHeader viaHeader = this.headerFactory.createViaHeader(this.sipStack.getIPAddress(), this.sipProvider.getListeningPoint().getPort(), transport, Utils.generateBranchId());
        CallIdHeader callIdHeader = this.sipProvider.getNewCallId();
        CSeqHeader cSeqHeader = this.headerFactory.createCSeqHeader(1, "INVITE");
        ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
        viaHeaders.add(viaHeader);
        Request invite = this.messageFactory.createRequest((URI)requestURI, "INVITE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, this.headerFactory.createMaxForwardsHeader(70));
        if (this.sessionDescription != null) {
            ContentLengthHeader contentLengthHeader = this.headerFactory.createContentLengthHeader(this.sessionDescription.length());
            ContentTypeHeader contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
            invite.setContentLength(contentLengthHeader);
            invite.setContent((Object)this.sessionDescription, contentTypeHeader);
        }
        SipURI contactURI = this.addressFactory.createSipURI(user, this.sipStack.getIPAddress());
        contactURI.setTransportParam("TCP");
        Address contactAddress = this.addressFactory.createAddress(displayName, (URI)contactURI);
        contactURI.setPort(this.sipProvider.getListeningPoint().getPort());
        ContactHeader contactHeader = this.headerFactory.createContactHeader(contactAddress);
        invite.addHeader((Header)contactHeader);
        RequireHeader requireHeader = this.headerFactory.createRequireHeader("100rel");
        AllowHeader allowHeader = this.headerFactory.createAllowHeader("UPDATE");
        invite.addHeader((Header)requireHeader);
        invite.addHeader((Header)allowHeader);
        ClientTransaction clientTransaction = this.sipProvider.getNewClientTransaction(invite);
        this.sessionData = new SessionData(fromAddress, toAddress, callIdHeader, (Transaction)clientTransaction, true);
        clientTransaction.sendRequest();
        System.out.println("Sent message:");
        System.out.println("-------------------------------------");
        System.out.println(invite.toString());
        System.out.println("-------------------------------------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean answerCall(String sdpParameters) throws TransactionDoesNotExistException, ParseException, SipException, InvalidArgumentException {
        SIPUserAgentServer sIPUserAgentServer = this.sipUserAgentServer;
        synchronized (sIPUserAgentServer) {
            try {
                Response response;
                if (this.sessionData == null) {
                    return false;
                }
                ServerTransaction lastTransaction = (ServerTransaction)this.sessionData.getLastTransaction();
                Request invite = lastTransaction.getRequest();
                ContentTypeHeader contentType = (ContentTypeHeader)invite.getHeader("Content-Type");
                byte[] bodyInBytes = invite.getRawContent();
                String body = new String(bodyInBytes);
                RequireHeader requireHeader = (RequireHeader)invite.getHeader("Require");
                if (requireHeader == null) {
                    Response response2;
                    if (sdpParameters != null) {
                        ContentTypeHeader responseCTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                        response2 = this.messageFactory.createResponse(200, invite, responseCTypeHeader, (Object)sdpParameters);
                        ToHeader responseToHeader = (ToHeader)response2.getHeader("To");
                        responseToHeader.setTag(Utils.generateTag());
                        SipURI responseContactURI = this.addressFactory.createSipURI(this.localUserName, this.sipStack.getIPAddress());
                        responseContactURI.setTransportParam("TCP");
                        responseContactURI.setPort(this.sipProvider.getListeningPoint().getPort());
                        Address responseContactAddress = this.addressFactory.createAddress(this.localUserDisplayName, (URI)responseContactURI);
                        ContactHeader responseContactHeader = this.headerFactory.createContactHeader(responseContactAddress);
                        response2.addHeader((Header)responseContactHeader);
                        AllowHeader allowHeader = this.headerFactory.createAllowHeader("UPDATE");
                        response2.addHeader((Header)allowHeader);
                        lastTransaction.sendResponse(response2);
                    } else if (contentType != null && body != null) {
                        response2 = this.messageFactory.createResponse(200, invite, contentType, (Object)body);
                        ToHeader responseToHeader = (ToHeader)response2.getHeader("To");
                        responseToHeader.setTag(Utils.generateTag());
                        SipURI responseContactURI = this.addressFactory.createSipURI(this.localUserName, this.sipStack.getIPAddress());
                        responseContactURI.setTransportParam("TCP");
                        responseContactURI.setPort(this.sipProvider.getListeningPoint().getPort());
                        Address responseContactAddress = this.addressFactory.createAddress(this.localUserDisplayName, (URI)responseContactURI);
                        ContactHeader responseContactHeader = this.headerFactory.createContactHeader(responseContactAddress);
                        response2.addHeader((Header)responseContactHeader);
                        AllowHeader allowHeader = this.headerFactory.createAllowHeader("UPDATE");
                        response2.addHeader((Header)allowHeader);
                        lastTransaction.sendResponse(response2);
                    } else if (this.sessionDescription != null) {
                        ContentTypeHeader responseCTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                        response2 = this.messageFactory.createResponse(200, invite, responseCTypeHeader, (Object)this.sessionDescription);
                        ToHeader responseToHeader = (ToHeader)response2.getHeader("To");
                        responseToHeader.setTag(Utils.generateTag());
                        SipURI responseContactURI = this.addressFactory.createSipURI(this.localUserName, this.sipStack.getIPAddress());
                        responseContactURI.setTransportParam("TCP");
                        responseContactURI.setPort(this.sipProvider.getListeningPoint().getPort());
                        Address responseContactAddress = this.addressFactory.createAddress(this.localUserDisplayName, (URI)responseContactURI);
                        ContactHeader responseContactHeader = this.headerFactory.createContactHeader(responseContactAddress);
                        response2.addHeader((Header)responseContactHeader);
                        AllowHeader allowHeader = this.headerFactory.createAllowHeader("UPDATE");
                        response2.addHeader((Header)allowHeader);
                        lastTransaction.sendResponse(response2);
                    } else {
                        response2 = this.messageFactory.createResponse(200, invite);
                        ToHeader responseToHeader = (ToHeader)response2.getHeader("To");
                        responseToHeader.setTag(Utils.generateTag());
                        SipURI responseContactURI = this.addressFactory.createSipURI(this.localUserName, this.sipStack.getIPAddress());
                        responseContactURI.setTransportParam("TCP");
                        responseContactURI.setPort(this.sipProvider.getListeningPoint().getPort());
                        Address responseContactAddress = this.addressFactory.createAddress(this.localUserDisplayName, (URI)responseContactURI);
                        ContactHeader responseContactHeader = this.headerFactory.createContactHeader(responseContactAddress);
                        response2.addHeader((Header)responseContactHeader);
                        AllowHeader allowHeader = this.headerFactory.createAllowHeader("UPDATE");
                        response2.addHeader((Header)allowHeader);
                        lastTransaction.sendResponse(response2);
                    }
                    this.sessionData.setDialog(lastTransaction.getDialog());
                    if (response2 != null) {
                        System.out.println("Sent message:");
                        System.out.println("-------------------------------------");
                        System.out.println(response2.toString());
                        System.out.println("-------------------------------------");
                    }
                    return true;
                }
                if (sdpParameters != null) {
                    System.out.println("++++++++++++++++++++++++");
                    System.out.println("ANSWER CALL METODA");
                    System.out.println("SDP parametri su null, ALI LOKALNI NISU!");
                    System.out.println("++++++++++++++++++++++++");
                    System.out.println(this.sessionDescription);
                    System.out.println("++++++++++++++++++++++++");
                    System.out.println("++++++++++++++++++++++++");
                    System.out.println("++++++++++++++++++++++++");
                    ContentTypeHeader responseCTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                    response = this.messageFactory.createResponse(183, invite, responseCTypeHeader, (Object)sdpParameters);
                    ToHeader responseToHeader = (ToHeader)response.getHeader("To");
                    responseToHeader.setTag(Utils.generateTag());
                    SipURI responseContactURI = this.addressFactory.createSipURI(this.localUserName, this.sipStack.getIPAddress());
                    responseContactURI.setTransportParam("TCP");
                    responseContactURI.setPort(this.sipProvider.getListeningPoint().getPort());
                    Address responseContactAddress = this.addressFactory.createAddress(this.localUserDisplayName, (URI)responseContactURI);
                    ContactHeader responseContactHeader = this.headerFactory.createContactHeader(responseContactAddress);
                    response.addHeader((Header)responseContactHeader);
                    response.addHeader((Header)requireHeader);
                    RSeqHeader rseqHeader = this.headerFactory.createRSeqHeader(1);
                    response.addHeader((Header)rseqHeader);
                    AllowHeader allowHeader = this.headerFactory.createAllowHeader("UPDATE");
                    response.addHeader((Header)allowHeader);
                    lastTransaction.sendResponse(response);
                } else if (contentType != null && body != null) {
                    response = this.messageFactory.createResponse(183, invite, contentType, (Object)body);
                    ToHeader responseToHeader = (ToHeader)response.getHeader("To");
                    responseToHeader.setTag(Utils.generateTag());
                    SipURI responseContactURI = this.addressFactory.createSipURI(this.localUserName, this.sipStack.getIPAddress());
                    responseContactURI.setTransportParam("TCP");
                    responseContactURI.setPort(this.sipProvider.getListeningPoint().getPort());
                    Address responseContactAddress = this.addressFactory.createAddress(this.localUserDisplayName, (URI)responseContactURI);
                    ContactHeader responseContactHeader = this.headerFactory.createContactHeader(responseContactAddress);
                    response.addHeader((Header)responseContactHeader);
                    response.addHeader((Header)requireHeader);
                    RSeqHeader rseqHeader = this.headerFactory.createRSeqHeader(1);
                    response.addHeader((Header)rseqHeader);
                    AllowHeader allowHeader = this.headerFactory.createAllowHeader("UPDATE");
                    response.addHeader((Header)allowHeader);
                    lastTransaction.sendResponse(response);
                } else if (this.sessionDescription != null) {
                    ContentTypeHeader responseCTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                    response = this.messageFactory.createResponse(183, invite, responseCTypeHeader, (Object)this.sessionDescription);
                    ToHeader responseToHeader = (ToHeader)response.getHeader("To");
                    responseToHeader.setTag(Utils.generateTag());
                    SipURI responseContactURI = this.addressFactory.createSipURI(this.localUserName, this.sipStack.getIPAddress());
                    responseContactURI.setTransportParam("TCP");
                    responseContactURI.setPort(this.sipProvider.getListeningPoint().getPort());
                    Address responseContactAddress = this.addressFactory.createAddress(this.localUserDisplayName, (URI)responseContactURI);
                    ContactHeader responseContactHeader = this.headerFactory.createContactHeader(responseContactAddress);
                    response.addHeader((Header)responseContactHeader);
                    response.addHeader((Header)requireHeader);
                    RSeqHeader rseqHeader = this.headerFactory.createRSeqHeader(1);
                    response.addHeader((Header)rseqHeader);
                    AllowHeader allowHeader = this.headerFactory.createAllowHeader("UPDATE");
                    response.addHeader((Header)allowHeader);
                    lastTransaction.sendResponse(response);
                } else {
                    response = this.messageFactory.createResponse(183, invite);
                    ToHeader responseToHeader = (ToHeader)response.getHeader("To");
                    responseToHeader.setTag(Utils.generateTag());
                    SipURI responseContactURI = this.addressFactory.createSipURI(this.localUserName, this.sipStack.getIPAddress());
                    responseContactURI.setTransportParam("TCP");
                    responseContactURI.setPort(this.sipProvider.getListeningPoint().getPort());
                    Address responseContactAddress = this.addressFactory.createAddress(this.localUserDisplayName, (URI)responseContactURI);
                    ContactHeader responseContactHeader = this.headerFactory.createContactHeader(responseContactAddress);
                    response.addHeader((Header)responseContactHeader);
                    response.addHeader((Header)requireHeader);
                    RSeqHeader rseqHeader = this.headerFactory.createRSeqHeader(1);
                    response.addHeader((Header)rseqHeader);
                    AllowHeader allowHeader = this.headerFactory.createAllowHeader("UPDATE");
                    response.addHeader((Header)allowHeader);
                    lastTransaction.sendResponse(response);
                }
                this.sessionData.setDialog(lastTransaction.getDialog());
                if (response != null) {
                    System.out.println("Sent message:");
                    System.out.println("-------------------------------------");
                    System.out.println(response.toString());
                    System.out.println("-------------------------------------");
                }
                return true;
            }
            catch (TransactionDoesNotExistException tdne) {
                System.out.println("Couldn't determine the invite request from the transactionId (or the corresponding response)!");
                tdne.printStackTrace();
                return false;
            }
            catch (ParseException pe) {
                pe.printStackTrace();
                return false;
            }
            catch (SipException se) {
                se.printStackTrace();
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hangupCall() throws SipException, ParseException, InvalidArgumentException, ClassCastException {
        try {
            if (this.sessionData == null) {
                return false;
            }
            if (this.sessionData.isSessionActive()) {
                URI requestURI = this.sessionData.getRemoteAddress().getURI();
                ToHeader toHeader = this.headerFactory.createToHeader(this.sessionData.getRemoteAddress(), this.sessionData.getDialog().getRemoteTag());
                FromHeader fromHeader = this.headerFactory.createFromHeader(this.sessionData.getLocalAddress(), this.sessionData.getDialog().getLocalTag());
                String transport = this.sipProvider.getListeningPoint().getTransport();
                ViaHeader viaHeader = this.headerFactory.createViaHeader(this.sipStack.getIPAddress(), this.sipProvider.getListeningPoint().getPort(), transport, Utils.generateBranchId());
                CallIdHeader callIdHeader = this.sessionData.getCallIdHeader();
                CSeqHeader cSeqHeader = this.headerFactory.createCSeqHeader(this.sessionData.getDialog().getLocalSequenceNumber() + 1, "BYE");
                ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
                viaHeaders.add(viaHeader);
                Request bye = this.messageFactory.createRequest(requestURI, "BYE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, this.headerFactory.createMaxForwardsHeader(70));
                ContentLengthHeader contentLengthHeader = this.headerFactory.createContentLengthHeader(0);
                bye.setContentLength(contentLengthHeader);
                ClientTransaction byeTransaction = this.sipProvider.getNewClientTransaction(bye);
                this.sessionData.getDialog().sendRequest(byeTransaction);
                System.out.println("Sent message:");
                System.out.println("-------------------------------------");
                System.out.println(byeTransaction.getRequest().toString());
                System.out.println("-------------------------------------");
                String user = this.sessionData.getRemoteUserDisplayName();
                if (user == null) {
                    user = this.sessionData.getRemoteUser();
                }
                System.out.println("-------------------------------------");
                System.out.println("Session to " + user + " at " + this.sessionData.getRemoteAddress() + " terminated");
                System.out.println("-------------------------------------");
                this.sessionData = null;
                return true;
            }
            if (this.sessionData.isLocallyInitiated()) {
                return false;
            }
            SIPUserAgentServer requestURI = this.sipUserAgentServer;
            synchronized (requestURI) {
                block15: {
                    if (this.sessionData != null) break block15;
                    return false;
                }
                ServerTransaction serverTransaction = (ServerTransaction)this.sessionData.getLastTransaction();
                Request request = serverTransaction.getRequest();
                Response decline = this.messageFactory.createResponse(603, request);
                serverTransaction.sendResponse(decline);
                String user = this.sessionData.getRemoteUserDisplayName();
                if (user == null) {
                    user = this.sessionData.getRemoteUser();
                }
                System.out.println("Sent message:");
                System.out.println("-------------------------------------");
                System.out.println(decline.toString());
                System.out.println("-------------------------------------");
                System.out.println("-------------------------------------");
                System.out.println("Call from " + user + " at " + this.sessionData.getRemoteAddress() + " has been rejected");
                System.out.println("-------------------------------------");
                this.sessionData = null;
                return true;
            }
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            System.out.println(npe.getMessage());
            return false;
        }
        catch (ParseException pe) {
            System.out.println("Error creating message! Session not terminated!");
            pe.printStackTrace();
            return false;
        }
        catch (InvalidArgumentException iae) {
            System.out.println("Error creating message! Session not terminated!");
            iae.printStackTrace();
            return false;
        }
        catch (SipException se) {
            System.out.println("Could not send message! Session not terminated!");
            se.printStackTrace();
            return false;
        }
        catch (ClassCastException cce) {
            System.out.println("Could not send message! Session not terminated!");
            cce.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean cancelCall() throws SipException, ClassCastException {
        SIPUserAgentServer sIPUserAgentServer = this.sipUserAgentServer;
        synchronized (sIPUserAgentServer) {
            if (this.sessionData == null) {
                return false;
            }
            if (this.sessionData.isSessionActive()) {
                return false;
            }
            if (!this.sessionData.isLocallyInitiated()) {
                return false;
            }
            try {
                String user = this.sessionData.getRemoteUserDisplayName();
                if (user == null) {
                    user = this.sessionData.getRemoteUser();
                }
                ClientTransaction inviteTransaction = (ClientTransaction)this.sessionData.getLastTransaction();
                Request cancel = inviteTransaction.createCancel();
                ClientTransaction cancelTransaction = this.sipProvider.getNewClientTransaction(cancel);
                cancelTransaction.sendRequest();
                System.out.println("Sent message:");
                System.out.println("-------------------------------------");
                System.out.println(cancel.toString());
                System.out.println("-------------------------------------");
                System.out.println("-------------------------------------");
                System.out.println("Cancelling call to " + user + " at " + this.sessionData.getRemoteAddress());
                System.out.println("-------------------------------------");
                return true;
            }
            catch (ClassCastException cce) {
                System.out.println("Could not send message! Session not canceled!");
                cce.printStackTrace();
                return false;
            }
            catch (SipException se) {
                System.out.println("Could not send message! Session not canceled!");
                se.printStackTrace();
                return false;
            }
        }
    }

    public void sendPRACK(String sdpContent, ResponseEvent responseEvent) throws SipException {
        Response response = responseEvent.getResponse();
        if (this.sessionData == null) {
            throw new SipException("PRACK can only be sent after an initial request!");
        }
        if (this.sessionData.getDialog() == null) {
            throw new SipException("PRACK can only be sent after a reliableprovisional response has been received!");
        }
        try {
            ListIterator recordRouteHeaders;
            SipURI requestURI = (SipURI)this.sessionData.getRemoteAddress().getURI().clone();
            requestURI.setTransportParam("TCP");
            SipURI remoteSipURI = (SipURI)this.sessionData.getRemoteAddress().getURI();
            remoteSipURI.removeParameter("transport");
            Address remoteAddress = this.addressFactory.createAddress((URI)remoteSipURI);
            ToHeader toHeader = this.headerFactory.createToHeader(remoteAddress, this.sessionData.getDialog().getRemoteTag());
            FromHeader fromHeader = this.headerFactory.createFromHeader(this.sessionData.getLocalAddress(), this.sessionData.getDialog().getLocalTag());
            String transport = this.sipProvider.getListeningPoint().getTransport();
            ViaHeader viaHeader = this.headerFactory.createViaHeader(this.sipStack.getIPAddress(), this.sipProvider.getListeningPoint().getPort(), transport, Utils.generateBranchId());
            CallIdHeader callIdHeader = this.sessionData.getCallIdHeader();
            CSeqHeader cSeqHeader = this.headerFactory.createCSeqHeader(this.sessionData.getDialog().getLocalSequenceNumber() + 1, "PRACK");
            CSeqHeader cseqHeader = (CSeqHeader)response.getHeader("CSeq");
            String method = cseqHeader.getMethod();
            int sequence = cseqHeader.getSequenceNumber();
            RSeqHeader rseqHeader = (RSeqHeader)response.getHeader("RSeq");
            int RSequence = rseqHeader.getSequenceNumber();
            RAckHeader rackHeader = this.headerFactory.createRAckHeader(RSequence, sequence, method);
            ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
            viaHeaders.add(viaHeader);
            Request prack = this.messageFactory.createRequest((URI)requestURI, "PRACK", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, this.headerFactory.createMaxForwardsHeader(70));
            ContentLengthHeader contentLengthHeader = null;
            if (sdpContent != null) {
                contentLengthHeader = this.headerFactory.createContentLengthHeader(sdpContent.length());
                ContentTypeHeader contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                prack.setContentLength(contentLengthHeader);
                prack.setContent((Object)sdpContent, contentTypeHeader);
            }
            prack.addHeader((Header)rackHeader);
            if (contentLengthHeader != null) {
                prack.setContentLength(contentLengthHeader);
            } else {
                contentLengthHeader.setContentLength(0);
                prack.setContentLength(contentLengthHeader);
            }
            prack.addHeader((Header)contentLengthHeader);
            ClientTransaction prackTransaction = this.sipProvider.getNewClientTransaction(prack);
            Dialog dialog = prackTransaction.getDialog();
            if (prack.getHeader("Route") == null && (recordRouteHeaders = response.getHeaders("Record-Route")) != null) {
                Vector<RecordRouteHeader> v = new Vector<RecordRouteHeader>();
                while (recordRouteHeaders.hasNext()) {
                    v.addElement((RecordRouteHeader)recordRouteHeaders.next());
                }
                int k = v.size() - 1;
                while (k >= 0) {
                    RouteHeader routeHeader = this.headerFactory.createRouteHeader(((RecordRouteHeader)v.elementAt(k)).getAddress());
                    prack.addHeader((Header)routeHeader);
                    --k;
                }
            }
            if (dialog != null) {
                dialog.sendRequest(prackTransaction);
            } else {
                prackTransaction.sendRequest();
            }
            System.out.println("Sent message:");
            System.out.println("-------------------------------------");
            System.out.println(prack.toString());
            System.out.println("-------------------------------------");
        }
        catch (InvalidArgumentException iae) {
            iae.printStackTrace();
            throw new SipException("Invalid header value!");
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            throw new SipException("Invalid header value!");
        }
    }

    public void sendUPDATE(String sdpContent) throws SipException {
        if (this.sessionData == null) {
            throw new SipException("UPDATE can only be sent after an initial request!");
        }
        if (this.sessionData.getDialog() == null) {
            throw new SipException("UPDATE can only be sent after a reliableprovisional response has been received!");
        }
        try {
            SipURI requestURI = (SipURI)this.sessionData.getRemoteAddress().getURI().clone();
            requestURI.setTransportParam("TCP");
            SipURI remoteSipURI = (SipURI)this.sessionData.getRemoteAddress().getURI();
            remoteSipURI.removeParameter("transport");
            Address remoteAddress = this.addressFactory.createAddress((URI)remoteSipURI);
            ToHeader toHeader = this.headerFactory.createToHeader(remoteAddress, this.sessionData.getDialog().getRemoteTag());
            FromHeader fromHeader = this.headerFactory.createFromHeader(this.sessionData.getLocalAddress(), this.sessionData.getDialog().getLocalTag());
            String transport = this.sipProvider.getListeningPoint().getTransport();
            ViaHeader viaHeader = this.headerFactory.createViaHeader(this.sipStack.getIPAddress(), this.sipProvider.getListeningPoint().getPort(), transport, Utils.generateBranchId());
            CallIdHeader callIdHeader = this.sessionData.getCallIdHeader();
            CSeqHeader cSeqHeader = this.headerFactory.createCSeqHeader(this.sessionData.getDialog().getLocalSequenceNumber() + 1, "UPDATE");
            ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
            viaHeaders.add(viaHeader);
            Request update = this.messageFactory.createRequest((URI)requestURI, "UPDATE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, this.headerFactory.createMaxForwardsHeader(70));
            ContentLengthHeader contentLengthHeader = null;
            if (sdpContent != null) {
                contentLengthHeader = this.headerFactory.createContentLengthHeader(sdpContent.length());
                ContentTypeHeader contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                update.setContentLength(contentLengthHeader);
                update.setContent((Object)sdpContent, contentTypeHeader);
            }
            if (contentLengthHeader != null) {
                update.setContentLength(contentLengthHeader);
            } else {
                contentLengthHeader.setContentLength(0);
                update.setContentLength(contentLengthHeader);
            }
            update.addHeader((Header)contentLengthHeader);
            ClientTransaction updateTransaction = this.sipProvider.getNewClientTransaction(update);
            Dialog dialog = updateTransaction.getDialog();
            if (update.getHeader("Route") == null) {
                Vector routeSet = this.sessionData.getRouteSet();
                int k = 0;
                while (k < routeSet.size()) {
                    RouteHeader routeHeader = this.headerFactory.createRouteHeader(((RecordRouteHeader)routeSet.elementAt(k)).getAddress());
                    update.addHeader((Header)routeHeader);
                    ++k;
                }
            }
            if (dialog != null) {
                dialog.sendRequest(updateTransaction);
            } else {
                updateTransaction.sendRequest();
            }
            System.out.println("Sent message:");
            System.out.println("-------------------------------------");
            System.out.println(update.toString());
            System.out.println("-------------------------------------");
        }
        catch (InvalidArgumentException iae) {
            iae.printStackTrace();
            throw new SipException("Invalid header value!");
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            throw new SipException("Invalid header value!");
        }
    }

    public void sendReInvite(String user, String displayName, String sdpParameters) throws SipException {
        if (this.sessionData == null || this.sessionData.getDialog() == null) {
            throw new SipException("A re-INVITE can be sent only after the dialog has beenestablished!");
        }
        try {
            ContentTypeHeader contentTypeHeader;
            Request reInvite = this.sessionData.getDialog().createRequest("INVITE");
            String reqURI = this.sessionData.getRemoteAddress().toString();
            reqURI = reqURI.substring(1, reqURI.length() - 1);
            SipURI requestURI = (SipURI)this.addressFactory.createURI(reqURI);
            reInvite.setRequestURI((URI)requestURI);
            String transport = this.sipProvider.getListeningPoint().getTransport();
            ViaHeader viaHeader = this.headerFactory.createViaHeader(this.sipStack.getIPAddress(), this.sipProvider.getListeningPoint().getPort(), transport, Utils.generateBranchId());
            reInvite.setHeader((Header)viaHeader);
            RequireHeader requireHeader = this.headerFactory.createRequireHeader("100rel");
            reInvite.addHeader((Header)requireHeader);
            AllowHeader allowHeader = this.headerFactory.createAllowHeader("UPDATE");
            reInvite.addHeader((Header)allowHeader);
            SipURI contactURI = this.addressFactory.createSipURI(user, this.sipStack.getIPAddress());
            contactURI.setTransportParam(transport);
            Address contactAddress = this.addressFactory.createAddress(displayName, (URI)contactURI);
            contactURI.setPort(this.sipProvider.getListeningPoint().getPort());
            ContactHeader contactHeader = this.headerFactory.createContactHeader(contactAddress);
            reInvite.addHeader((Header)contactHeader);
            reInvite.removeHeader("Route");
            Vector routeSet = this.sessionData.getRouteSet();
            int i = 0;
            while (i < routeSet.size()) {
                RecordRouteHeader recordRouteHeader = (RecordRouteHeader)routeSet.elementAt(i);
                RouteHeader routeHeader = this.headerFactory.createRouteHeader(recordRouteHeader.getAddress());
                reInvite.addHeader((Header)routeHeader);
                ++i;
            }
            if (sdpParameters != null) {
                ContentLengthHeader contentLengthHeader = this.headerFactory.createContentLengthHeader(sdpParameters.length());
                contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                reInvite.setContentLength(contentLengthHeader);
                reInvite.setContent((Object)sdpParameters, contentTypeHeader);
            } else if (this.sessionDescription != null) {
                ContentLengthHeader contentLengthHeader = this.headerFactory.createContentLengthHeader(this.sessionDescription.length());
                contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                reInvite.setContentLength(contentLengthHeader);
                reInvite.setContent((Object)this.sessionDescription, contentTypeHeader);
            }
            ClientTransaction clientTransaction = this.sipProvider.getNewClientTransaction(reInvite);
            this.sessionData.getDialog().sendRequest(clientTransaction);
            if (this.sessionData.getState() == 1) {
                this.sessionData.setState(3);
                this.sessionData.setPreviousState(1);
            } else if (this.sessionData.getState() == 2) {
                this.sessionData.setState(3);
                this.sessionData.setPreviousState(2);
            }
            System.out.println("Sent message:");
            System.out.println("-------------------------------------");
            System.out.println(reInvite.toString());
            System.out.println("-------------------------------------");
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            throw new SipException("Invalid header value!");
        }
        catch (InvalidArgumentException iae) {
            iae.printStackTrace();
            throw new SipException("Invalid header value!");
        }
    }

    protected SipProvider getSipProvider() {
        return this.sipProvider;
    }

    protected SipStack getSipStack() {
        return this.sipStack;
    }

    protected AddressFactory getAddressFactory() {
        return this.addressFactory;
    }

    protected MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    protected HeaderFactory getHeaderFactory() {
        return this.headerFactory;
    }

    public void setSessionData(SessionData sessionData) {
        this.sessionData = sessionData;
    }

    public SessionData getSessionData() {
        return this.sessionData;
    }

    public void setSessionDescription(String sessionDescription) {
        this.sessionDescription = sessionDescription;
    }

    public String getSessionDescription() {
        return this.sessionDescription;
    }

    public String getMessageDigest(String text, String algorithm, String encoding) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        char[] c = null;
        if (text != null) {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            byte[] bytes = null;
            bytes = encoding == null ? text.getBytes() : text.getBytes(encoding);
            md.update(bytes);
            byte[] raw = md.digest();
            int pos = 0;
            c = new char[raw.length * 2];
            int i = 0;
            while (i < raw.length) {
                c[pos++] = toHex[raw[i] >> 4 & 0xF];
                c[pos++] = toHex[raw[i] & 0xF];
                ++i;
            }
        }
        return new String(c);
    }

    public String toNonceCount(int n) {
        String result = null;
        String num = Integer.toString(n);
        int length = num.length();
        while (length < 8) {
            num = result = "0" + num;
            ++length;
        }
        return result;
    }

    public void exit(Component parentComponent, String errorMessage, String errorTitle) {
        JOptionPane.showMessageDialog(parentComponent, errorMessage, errorTitle, 0);
        System.exit(501);
    }

    public String getServiceSIPURI() {
        return this.serviceSIPURI;
    }

    public void setServiceSIPURI(String serviceSIPURI) {
        this.serviceSIPURI = serviceSIPURI;
    }

    public SIPUserAgentServer getSipUserAgentServer() {
        return this.sipUserAgentServer;
    }

    public void setSipUserAgentServer(SIPUserAgentServer sipUserAgentServer) {
        this.sipUserAgentServer = sipUserAgentServer;
    }
}

