/*
 * Decompiled with CFR 0.152.
 */
package hr.fer.tel.nims.dsa.client.sipAgent;

import java.util.ListIterator;
import java.util.Vector;
import javax.sip.Dialog;
import javax.sip.Transaction;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.header.CallIdHeader;
import javax.sip.header.RecordRouteHeader;
import javax.sip.message.Response;

public class SessionData {
    private Address localAddress;
    private Address remoteAddress;
    private CallIdHeader callIdHeader;
    private Transaction lastTransaction;
    private boolean isSessionActive = false;
    private boolean isLocallyInitiated;
    private Dialog dialog;
    private Vector<RecordRouteHeader> routeSet;
    public static final int STARTED = 0;
    public static final int IDLE = 1;
    public static final int CHANGE_SERVICE_OCCURRED = 2;
    public static final int CHANGE_CLIENT_OCCURRED = 3;
    private int state = 0;
    private int previousState = 0;

    public SessionData(Address localAddress, Address remoteAddress, CallIdHeader callIdHeader, Transaction lastTransaction, boolean locallyInitiated) {
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.lastTransaction = lastTransaction;
        this.callIdHeader = callIdHeader;
        this.isLocallyInitiated = locallyInitiated;
    }

    public String getRemoteUser() {
        SipURI sipURI = (SipURI)this.remoteAddress.getURI();
        return sipURI.getUser();
    }

    public String getRemoteHost() {
        SipURI sipURI = (SipURI)this.remoteAddress.getURI();
        return sipURI.getHost();
    }

    public int getRemotePort() {
        SipURI sipURI = (SipURI)this.remoteAddress.getURI();
        return sipURI.getPort();
    }

    public String getCallId() {
        return this.callIdHeader.getCallId();
    }

    public CallIdHeader getCallIdHeader() {
        return this.callIdHeader;
    }

    public Transaction getLastTransaction() {
        return this.lastTransaction;
    }

    public void setLastTransaction(Transaction lastTransaction) {
        this.lastTransaction = lastTransaction;
    }

    public void setRouteSet(Response response) {
        ListIterator recordRouteHeaders = response.getHeaders("Record-Route");
        if (recordRouteHeaders != null) {
            Vector<RecordRouteHeader> v = new Vector<RecordRouteHeader>();
            while (recordRouteHeaders.hasNext()) {
                v.addElement((RecordRouteHeader)recordRouteHeaders.next());
            }
            this.routeSet = new Vector();
            int k = v.size() - 1;
            while (k >= 0) {
                this.routeSet.addElement((RecordRouteHeader)v.elementAt(k));
                --k;
            }
        }
    }

    public Vector getRouteSet() {
        return this.routeSet;
    }

    public boolean isSessionActive() {
        return this.isSessionActive;
    }

    public void setActive(boolean active) {
        this.isSessionActive = active;
    }

    public boolean isLocallyInitiated() {
        return this.isLocallyInitiated;
    }

    public String getRemoteUserDisplayName() {
        return this.remoteAddress.getDisplayName();
    }

    public Dialog getDialog() {
        return this.dialog;
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
    }

    public String getLocalUser() {
        SipURI sipURI = (SipURI)this.localAddress.getURI();
        return sipURI.getUser();
    }

    public String getLocalUserDisplayName() {
        return this.localAddress.getDisplayName();
    }

    public Address getRemoteAddress() {
        return this.remoteAddress;
    }

    public Address getLocalAddress() {
        return this.localAddress;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getPreviousState() {
        return this.previousState;
    }

    public void setPreviousState(int previousState) {
        this.previousState = previousState;
    }
}

