/*
 * Decompiled with CFR 0.152.
 */
package hr.fer.tel.nims.dsa.server;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public class ConfigurationHandler {
    private String configurationFile;
    private Properties configurationProperties;
    public final String NAME_PROPERTY = "javax.sip.STACK_NAME";
    public final String ADDRESS_PROPERTY = "javax.sip.IP_ADDRESS";
    public final String PORT_PROPERTY = "hr.fer.teletk.sipagent.PORT";
    public final String TRANSPORT_PROPERTY = "hr.fer.teletk.sipagent.TRANSPORT";
    public final String RETRANSMISSION_FILTER_PROPERTY = "javax.sip.RETRANSMISSON_FILTER";
    public final String SERVER_LOG_PROPERTY = "gov.nist.javax.sip.SERVER_LOG";
    public final String DEBUG_LOG_PROPERTY = "gov.nist.javax.sip.DEBUG_LOG";
    public final String TRACE_LEVEL_PROPERTY = "gov.nist.javax.sip.TRACE_LEVEL";

    public ConfigurationHandler(String configurationFile) {
        this.configurationFile = configurationFile;
        this.configurationProperties = new Properties();
    }

    public void init() throws IOException, IllegalArgumentException {
        Properties confProperties = new Properties();
        confProperties.load(new FileInputStream(this.configurationFile));
        this.configurationProperties.setProperty("javax.sip.STACK_NAME", confProperties.getProperty("NAME"));
        this.configurationProperties.setProperty("javax.sip.IP_ADDRESS", confProperties.getProperty("IP_ADDRESS"));
        this.configurationProperties.setProperty("hr.fer.teletk.sipagent.TRANSPORT", confProperties.getProperty("TRANSPORT"));
        this.configurationProperties.setProperty("hr.fer.teletk.sipagent.PORT", confProperties.getProperty("PORT"));
        this.configurationProperties.setProperty("javax.sip.RETRANSMISSON_FILTER", confProperties.getProperty("RETRANSMISSION"));
        this.configurationProperties.setProperty("gov.nist.javax.sip.DEBUG_LOG", confProperties.getProperty("DEBUG_LOG"));
        this.configurationProperties.setProperty("gov.nist.javax.sip.SERVER_LOG", confProperties.getProperty("SERVER_LOG"));
        this.configurationProperties.setProperty("gov.nist.javax.sip.TRACE_LEVEL", confProperties.getProperty("TRACE_LEVEL"));
        if (!this.isIpAddressValid(this.configurationProperties.getProperty("javax.sip.IP_ADDRESS"))) {
            throw new IllegalArgumentException("IP address value in the configuration file is invalid!");
        }
        if (!this.isNameValid(this.configurationProperties.getProperty("javax.sip.STACK_NAME"))) {
            throw new IllegalArgumentException("The name for the user agent must be specified in the configuration file!");
        }
        if (!this.isTransportPortValid(this.configurationProperties.getProperty("hr.fer.teletk.sipagent.PORT"))) {
            throw new IllegalArgumentException("Transport protocol port number value in the configuration file is invalid!");
        }
        if (!this.isTransportProtocolValid(this.configurationProperties.getProperty("hr.fer.teletk.sipagent.TRANSPORT"))) {
            throw new IllegalArgumentException("Transport protocol value in the configuration file is invalid!");
        }
        if (!this.isSipRetransmissionFilterValid(this.configurationProperties.getProperty("javax.sip.RETRANSMISSON_FILTER"))) {
            throw new IllegalArgumentException("SIP retransmission filter value in the configuration file is invalid!");
        }
        if (!this.isStackTraceLevelValid(this.configurationProperties.getProperty("gov.nist.javax.sip.TRACE_LEVEL"))) {
            throw new IllegalArgumentException("Trace level value in the configuration file is invalid!");
        }
    }

    private boolean isIpAddressValid(String ipAddress) {
        String d;
        String c;
        String b;
        if (ipAddress == null) {
            return false;
        }
        if (ipAddress.compareTo("") == 0) {
            return false;
        }
        StringTokenizer addressTokenizer = new StringTokenizer(ipAddress, ".");
        String a = addressTokenizer.nextToken();
        try {
            b = addressTokenizer.nextToken();
            c = addressTokenizer.nextToken();
            d = addressTokenizer.nextToken();
        }
        catch (NoSuchElementException nsee) {
            return false;
        }
        try {
            int aint = Integer.parseInt(a);
            int bint = Integer.parseInt(b);
            int cint = Integer.parseInt(c);
            int dint = Integer.parseInt(d);
            if (aint <= -1 || bint <= -1 || cint <= -1 || dint <= -1) {
                return false;
            }
            if (aint >= 255 || bint >= 255 || cint >= 255 || dint >= 255) {
                return false;
            }
            if (aint == 0 || dint == 0) {
                return false;
            }
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private boolean isNameValid(String name) {
        return name != null;
    }

    private boolean isTransportPortValid(String portString) {
        int port;
        if (portString == null) {
            return true;
        }
        try {
            port = Integer.parseInt(portString);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return port <= 65535 && port >= 1025;
    }

    private boolean isTransportProtocolValid(String transport) {
        if (transport == null) {
            return true;
        }
        if (transport.compareTo("") == 0) {
            return false;
        }
        return transport.compareToIgnoreCase("UDP") == 0 || transport.compareToIgnoreCase("TCP") == 0;
    }

    private boolean isSipRetransmissionFilterValid(String retransmissionFilter) {
        if (retransmissionFilter == null) {
            return true;
        }
        if (retransmissionFilter.compareTo("") == 0) {
            return false;
        }
        return retransmissionFilter.compareToIgnoreCase("ON") == 0 || retransmissionFilter.compareToIgnoreCase("OFF") == 0;
    }

    private boolean isStackTraceLevelValid(String traceLevel) {
        if (traceLevel == null) {
            return true;
        }
        if (traceLevel.compareTo("") == 0) {
            return false;
        }
        return traceLevel.compareTo("16") == 0 || traceLevel.compareTo("32") == 0;
    }

    public String getIpAddress() {
        return this.configurationProperties.getProperty("javax.sip.IP_ADDRESS");
    }

    public String getName() {
        return this.configurationProperties.getProperty("javax.sip.STACK_NAME");
    }

    public int getTransportPort() {
        String stackPort = this.configurationProperties.getProperty("hr.fer.teletk.sipagent.PORT");
        if (stackPort == null) {
            return 5060;
        }
        return Integer.parseInt(stackPort);
    }

    public String getTransportProtocol() {
        String transportProtocol = this.configurationProperties.getProperty("hr.fer.teletk.sipagent.TRANSPORT");
        if (transportProtocol == null) {
            return "UDP";
        }
        return transportProtocol;
    }

    public boolean getRetransmissionFilter() {
        String retransmissionFilter = this.configurationProperties.getProperty("javax.sip.RETRANSMISSON_FILTER");
        if (retransmissionFilter == null) {
            return false;
        }
        return retransmissionFilter.compareToIgnoreCase("ON") == 0;
    }

    public String getServerLog() {
        return this.configurationProperties.getProperty("gov.nist.javax.sip.SERVER_LOG");
    }

    public String getDebugLog() {
        return this.configurationProperties.getProperty("gov.nist.javax.sip.DEBUG_LOG");
    }

    public String getTraceLevel() {
        String traceLevel = this.configurationProperties.getProperty("gov.nist.javax.sip.TRACE_LEVEL");
        if (traceLevel == null) {
            return "16";
        }
        return traceLevel;
    }

    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }
}

