/*
 * Decompiled with CFR 0.152.
 */
package hr.fer.tel.nims.dsa.server.sipagent;

import gov.nist.javax.sip.Utils;
import hr.fer.tel.nims.dsa.server.ConfigurationHandler;
import hr.fer.tel.nims.dsa.server.sipagent.SIPUserAgentServer;
import hr.fer.tel.nims.dsa.server.sipagent.SessionData;
import hr.fer.tel.nims.dsa.server.sipagent.SessionMapping;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Properties;
import java.util.TooManyListenersException;
import javax.sip.ClientTransaction;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.PeerUnavailableException;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.Transaction;
import javax.sip.TransactionDoesNotExistException;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.AllowHeader;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentLengthHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.RAckHeader;
import javax.sip.header.RSeqHeader;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.RequireHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;

public class SIPUserAgent {
    private ConfigurationHandler configurationHandler;
    boolean isClient;
    private SipProvider sipProvider;
    private SipStack sipStack;
    private AddressFactory addressFactory;
    private HeaderFactory headerFactory;
    private MessageFactory messageFactory;
    private SIPUserAgentServer sipUserAgentServer;
    private SessionMapping sessionDataMapping;
    private String sdpParameters;
    private String localUserName;
    private String localUserDisplayName;

    public SIPUserAgent(SIPUserAgentServer sipUserAgentServer, ConfigurationHandler configurationHandler, boolean isClient) {
        this.isClient = isClient;
        this.sipUserAgentServer = sipUserAgentServer;
        this.configurationHandler = configurationHandler;
        this.sessionDataMapping = new SessionMapping();
    }

    public void start() throws SipException, ObjectInUseException, InvalidArgumentException {
        SipFactory sipFactory = SipFactory.getInstance();
        sipFactory.setPathName("gov.nist");
        this.addressFactory = sipFactory.createAddressFactory();
        this.headerFactory = sipFactory.createHeaderFactory();
        this.messageFactory = sipFactory.createMessageFactory();
        Properties stackProperties = this.configurationHandler.getConfigurationProperties();
        if (stackProperties == null) {
            throw new SipException("Stack configuration not loaded or invalid!");
        }
        this.sipStack = sipFactory.createSipStack(stackProperties);
        ListeningPoint listeningPoint = null;
        int port = 0;
        String transport = null;
        try {
            port = Integer.valueOf(stackProperties.getProperty("hr.fer.teletk.sipagent.PORT"));
            transport = stackProperties.getProperty("hr.fer.teletk.sipagent.TRANSPORT");
            if (port == 0 || transport == null) {
                throw new SipException("Stack configuration not loaded or invalid!");
            }
            listeningPoint = this.sipStack.createListeningPoint(port, transport);
            this.sipProvider = this.sipStack.createSipProvider(listeningPoint);
        }
        catch (NullPointerException npe) {
            throw new SipException("Couldn't get listening point!");
        }
        catch (ObjectInUseException oiue) {
            throw oiue;
        }
        catch (InvalidArgumentException iae) {
            throw iae;
        }
        catch (PeerUnavailableException pue) {
            throw new SipException("Stack could not be initialized!");
        }
        System.out.println("SIP User Agent started @ port: " + port);
        try {
            this.sipProvider.addSipListener((SipListener)this.sipUserAgentServer);
        }
        catch (TooManyListenersException tmle) {
            throw new SipException("Error registering SipListener - SipListener already registered!");
        }
    }

    public void stop() throws Exception {
        this.sessionDataMapping.clearAll();
        this.sipUserAgentServer.getInviteSessionMapping().clearAll();
        if (this.sipStack == null) {
            return;
        }
        if (this.sipProvider != null) {
            this.sipProvider.removeSipListener((SipListener)this.sipUserAgentServer);
            try {
                this.sipStack.deleteSipProvider(this.sipProvider);
            }
            catch (ObjectInUseException oiue) {
                oiue.printStackTrace();
                throw new Exception("Couldn't stop the stack - provider in use!");
            }
            Iterator listeningPoints = this.sipStack.getListeningPoints();
            if (listeningPoints != null && listeningPoints.hasNext()) {
                ListeningPoint listeningPoint = (ListeningPoint)listeningPoints.next();
                try {
                    this.sipStack.deleteListeningPoint(listeningPoint);
                }
                catch (ObjectInUseException oiue) {
                    oiue.printStackTrace();
                    throw new Exception("Couldn't stop the stack - listening point in use!");
                }
            }
            this.sipStack = null;
        }
    }

    public void placeCall(String sipURI, String user, String displayName, String sdpParameters) throws NullPointerException, InvalidArgumentException, ParseException, SipException, ClassCastException {
        if (this.isClient) {
            return;
        }
        try {
            ContentTypeHeader contentTypeHeader;
            ContentLengthHeader contentLengthHeader;
            SipURI fromSipURI = this.addressFactory.createSipURI(user, this.sipStack.getIPAddress());
            fromSipURI.setPort(this.sipProvider.getListeningPoint().getPort());
            Address fromAddress = this.addressFactory.createAddress(displayName, (URI)fromSipURI);
            FromHeader fromHeader = this.headerFactory.createFromHeader(fromAddress, Utils.generateTag());
            SipURI toURI = (SipURI)this.addressFactory.createURI(sipURI);
            Address toAddress = this.addressFactory.createAddress((URI)toURI);
            ToHeader toHeader = this.headerFactory.createToHeader(toAddress, null);
            URI requestURI = (URI)toURI.clone();
            String transport = this.sipProvider.getListeningPoint().getTransport();
            ViaHeader viaHeader = this.headerFactory.createViaHeader(this.sipStack.getIPAddress(), this.sipProvider.getListeningPoint().getPort(), transport, Utils.generateBranchId());
            CallIdHeader callIdHeader = this.sipProvider.getNewCallId();
            CSeqHeader cSeqHeader = this.headerFactory.createCSeqHeader(1, "INVITE");
            RequireHeader requireHeader = this.headerFactory.createRequireHeader("100rel");
            AllowHeader allowHeader = this.headerFactory.createAllowHeader("UPDATE");
            ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
            viaHeaders.add(viaHeader);
            Request invite = this.messageFactory.createRequest(requestURI, "INVITE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, this.headerFactory.createMaxForwardsHeader(70));
            if (sdpParameters != null) {
                contentLengthHeader = this.headerFactory.createContentLengthHeader(sdpParameters.length());
                contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                invite.setContentLength(contentLengthHeader);
                invite.setContent((Object)sdpParameters, contentTypeHeader);
            } else if (this.sdpParameters != null) {
                contentLengthHeader = this.headerFactory.createContentLengthHeader(this.sdpParameters.length());
                contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                invite.setContentLength(contentLengthHeader);
                invite.setContent((Object)this.sdpParameters, contentTypeHeader);
            }
            SipURI contactURI = this.addressFactory.createSipURI(user, this.sipStack.getIPAddress());
            Address contactAddress = this.addressFactory.createAddress(displayName, (URI)contactURI);
            ContactHeader contactHeader = this.headerFactory.createContactHeader(contactAddress);
            invite.addHeader((Header)contactHeader);
            invite.addHeader((Header)requireHeader);
            invite.addHeader((Header)allowHeader);
            ClientTransaction clientTransaction = this.sipProvider.getNewClientTransaction(invite);
            SessionData sessionData = new SessionData(fromAddress, toAddress, callIdHeader, (Transaction)clientTransaction, true);
            this.sessionDataMapping.addSessionData(sessionData);
            clientTransaction.sendRequest();
            System.out.println("Sent message:");
            System.out.println("-------------------------------------");
            System.out.println(invite.toString());
            System.out.println("-------------------------------------");
        }
        catch (NullPointerException npe) {
            throw npe;
        }
        catch (InvalidArgumentException iae) {
            throw iae;
        }
        catch (ParseException pe) {
            throw pe;
        }
        catch (ClassCastException cce) {
            throw cce;
        }
    }

    public void sendReInvite(String user, String displayName, String sdpParameters, String sessionId) throws SipException {
        SessionData sessionData = this.sessionDataMapping.getSessionData(sessionId);
        if (sessionData == null || sessionData.getDialog() == null) {
            throw new SipException("A re-INVITE can be sent only after the dialog has been established!");
        }
        try {
            ContentTypeHeader contentTypeHeader;
            ContentLengthHeader contentLengthHeader;
            SipURI requestURI = (SipURI)sessionData.getRemoteAddress().getURI().clone();
            requestURI.setTransportParam("TCP");
            ToHeader toHeader = this.headerFactory.createToHeader(sessionData.getRemoteAddress(), sessionData.getDialog().getRemoteTag());
            FromHeader fromHeader = this.headerFactory.createFromHeader(sessionData.getLocalAddress(), sessionData.getDialog().getLocalTag());
            String transport = this.sipProvider.getListeningPoint().getTransport();
            ViaHeader viaHeader = this.headerFactory.createViaHeader(this.sipStack.getIPAddress(), this.sipProvider.getListeningPoint().getPort(), transport, Utils.generateBranchId());
            CallIdHeader callIdHeader = sessionData.getCallIdHeader();
            CSeqHeader cSeqHeader = this.headerFactory.createCSeqHeader(sessionData.getDialog().getLocalSequenceNumber(), "UPDATE");
            RequireHeader requireHeader = this.headerFactory.createRequireHeader("100rel");
            ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
            viaHeaders.add(viaHeader);
            Request reInvite = this.messageFactory.createRequest((URI)requestURI, "UPDATE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, this.headerFactory.createMaxForwardsHeader(70));
            if (sdpParameters != null) {
                contentLengthHeader = this.headerFactory.createContentLengthHeader(sdpParameters.length());
                contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                reInvite.setContentLength(contentLengthHeader);
                reInvite.setContent((Object)sdpParameters, contentTypeHeader);
            } else if (this.sdpParameters != null) {
                contentLengthHeader = this.headerFactory.createContentLengthHeader(this.sdpParameters.length());
                contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                reInvite.setContentLength(contentLengthHeader);
                reInvite.setContent((Object)this.sdpParameters, contentTypeHeader);
            }
            SipURI contactURI = this.addressFactory.createSipURI(user, this.sipStack.getIPAddress());
            contactURI.setTransportParam(transport);
            contactURI.setPort(this.sipProvider.getListeningPoint().getPort());
            Address contactAddress = this.addressFactory.createAddress(displayName, (URI)contactURI);
            ContactHeader contactHeader = this.headerFactory.createContactHeader(contactAddress);
            reInvite.addHeader((Header)contactHeader);
            reInvite.addHeader((Header)requireHeader);
            reInvite.removeHeader("Route");
            ListIterator recordRouteHeaders = sessionData.getDialog().getFirstTransaction().getRequest().getHeaders("Record-Route");
            if (recordRouteHeaders != null) {
                while (recordRouteHeaders.hasNext()) {
                    RouteHeader routeHeader = this.headerFactory.createRouteHeader(((RecordRouteHeader)recordRouteHeaders.next()).getAddress());
                    reInvite.addHeader((Header)routeHeader);
                }
            }
            ClientTransaction clientTransaction = this.sipProvider.getNewClientTransaction(reInvite);
            sessionData.getDialog().sendRequest(clientTransaction);
            System.out.println("Sent message:");
            System.out.println("-------------------------------------");
            System.out.println(reInvite.toString());
            System.out.println("-------------------------------------");
        }
        catch (InvalidArgumentException iae) {
            iae.printStackTrace();
            throw new SipException("Invalid header value!");
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            throw new SipException("Invalid header value!");
        }
    }

    public boolean answerCall(String sdpParameters, Request request) throws TransactionDoesNotExistException, ParseException, SipException, InvalidArgumentException {
        try {
            Response response;
            SessionData sessionData = this.sessionDataMapping.getSessionData(((CallIdHeader)request.getHeader("Call-ID")).getCallId());
            if (sessionData == null) {
                return false;
            }
            ServerTransaction lastTransaction = (ServerTransaction)sessionData.getLastTransaction();
            Request invite = lastTransaction.getRequest();
            ContentTypeHeader contentType = (ContentTypeHeader)invite.getHeader("Content-Type");
            byte[] bodyInBytes = invite.getRawContent();
            String body = new String(bodyInBytes);
            RequireHeader requireHeader = (RequireHeader)invite.getHeader("Require");
            if (requireHeader == null) {
                Response response2;
                if (sdpParameters != null) {
                    ContentTypeHeader responseCTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                    response2 = this.messageFactory.createResponse(200, invite, responseCTypeHeader, (Object)sdpParameters);
                    ToHeader responseToHeader = (ToHeader)response2.getHeader("To");
                    responseToHeader.setTag(Utils.generateTag());
                    SipURI responseContactURI = this.addressFactory.createSipURI(this.localUserName, this.sipStack.getIPAddress());
                    responseContactURI.setTransportParam("TCP");
                    responseContactURI.setPort(this.sipProvider.getListeningPoint().getPort());
                    Address responseContactAddress = this.addressFactory.createAddress(this.localUserDisplayName, (URI)responseContactURI);
                    ContactHeader responseContactHeader = this.headerFactory.createContactHeader(responseContactAddress);
                    response2.addHeader((Header)responseContactHeader);
                    AllowHeader allowHeader = this.headerFactory.createAllowHeader("UPDATE");
                    response2.addHeader((Header)allowHeader);
                    lastTransaction.sendResponse(response2);
                } else if (contentType != null && body != null) {
                    response2 = this.messageFactory.createResponse(200, invite, contentType, (Object)body);
                    ToHeader responseToHeader = (ToHeader)response2.getHeader("To");
                    responseToHeader.setTag(Utils.generateTag());
                    SipURI responseContactURI = this.addressFactory.createSipURI(this.localUserName, this.sipStack.getIPAddress());
                    responseContactURI.setTransportParam("TCP");
                    responseContactURI.setPort(this.sipProvider.getListeningPoint().getPort());
                    Address responseContactAddress = this.addressFactory.createAddress(this.localUserDisplayName, (URI)responseContactURI);
                    ContactHeader responseContactHeader = this.headerFactory.createContactHeader(responseContactAddress);
                    response2.addHeader((Header)responseContactHeader);
                    AllowHeader allowHeader = this.headerFactory.createAllowHeader("UPDATE");
                    response2.addHeader((Header)allowHeader);
                    lastTransaction.sendResponse(response2);
                } else if (this.sdpParameters != null) {
                    ContentTypeHeader responseCTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                    response2 = this.messageFactory.createResponse(200, invite, responseCTypeHeader, (Object)this.sdpParameters);
                    ToHeader responseToHeader = (ToHeader)response2.getHeader("To");
                    responseToHeader.setTag(Utils.generateTag());
                    SipURI responseContactURI = this.addressFactory.createSipURI(this.localUserName, this.sipStack.getIPAddress());
                    responseContactURI.setTransportParam("TCP");
                    responseContactURI.setPort(this.sipProvider.getListeningPoint().getPort());
                    Address responseContactAddress = this.addressFactory.createAddress(this.localUserDisplayName, (URI)responseContactURI);
                    ContactHeader responseContactHeader = this.headerFactory.createContactHeader(responseContactAddress);
                    response2.addHeader((Header)responseContactHeader);
                    AllowHeader allowHeader = this.headerFactory.createAllowHeader("UPDATE");
                    response2.addHeader((Header)allowHeader);
                    lastTransaction.sendResponse(response2);
                } else {
                    response2 = this.messageFactory.createResponse(200, invite);
                    ToHeader responseToHeader = (ToHeader)response2.getHeader("To");
                    responseToHeader.setTag(Utils.generateTag());
                    SipURI responseContactURI = this.addressFactory.createSipURI(this.localUserName, this.sipStack.getIPAddress());
                    responseContactURI.setTransportParam("TCP");
                    responseContactURI.setPort(this.sipProvider.getListeningPoint().getPort());
                    Address responseContactAddress = this.addressFactory.createAddress(this.localUserDisplayName, (URI)responseContactURI);
                    ContactHeader responseContactHeader = this.headerFactory.createContactHeader(responseContactAddress);
                    response2.addHeader((Header)responseContactHeader);
                    AllowHeader allowHeader = this.headerFactory.createAllowHeader("UPDATE");
                    response2.addHeader((Header)allowHeader);
                    lastTransaction.sendResponse(response2);
                }
                sessionData.setDialog(lastTransaction.getDialog());
                if (response2 != null) {
                    System.out.println("Sent message:");
                    System.out.println("-------------------------------------");
                    System.out.println(response2.toString());
                    System.out.println("-------------------------------------");
                }
                return true;
            }
            if (sdpParameters != null) {
                ContentTypeHeader responseCTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                response = this.messageFactory.createResponse(183, invite, responseCTypeHeader, (Object)sdpParameters);
                ToHeader responseToHeader = (ToHeader)response.getHeader("To");
                responseToHeader.setTag(Utils.generateTag());
                SipURI responseContactURI = this.addressFactory.createSipURI(this.localUserName, this.sipStack.getIPAddress());
                responseContactURI.setTransportParam("TCP");
                responseContactURI.setPort(this.sipProvider.getListeningPoint().getPort());
                Address responseContactAddress = this.addressFactory.createAddress(this.localUserDisplayName, (URI)responseContactURI);
                ContactHeader responseContactHeader = this.headerFactory.createContactHeader(responseContactAddress);
                response.addHeader((Header)responseContactHeader);
                response.addHeader((Header)requireHeader);
                RSeqHeader rseqHeader = this.headerFactory.createRSeqHeader(1);
                response.addHeader((Header)rseqHeader);
                AllowHeader allowHeader = this.headerFactory.createAllowHeader("UPDATE");
                response.addHeader((Header)allowHeader);
                lastTransaction.sendResponse(response);
            } else if (contentType != null && body != null) {
                response = this.messageFactory.createResponse(183, invite, contentType, (Object)body);
                ToHeader responseToHeader = (ToHeader)response.getHeader("To");
                responseToHeader.setTag(Utils.generateTag());
                SipURI responseContactURI = this.addressFactory.createSipURI(this.localUserName, this.sipStack.getIPAddress());
                responseContactURI.setTransportParam("TCP");
                responseContactURI.setPort(this.sipProvider.getListeningPoint().getPort());
                Address responseContactAddress = this.addressFactory.createAddress(this.localUserDisplayName, (URI)responseContactURI);
                ContactHeader responseContactHeader = this.headerFactory.createContactHeader(responseContactAddress);
                response.addHeader((Header)responseContactHeader);
                response.addHeader((Header)requireHeader);
                RSeqHeader rseqHeader = this.headerFactory.createRSeqHeader(1);
                response.addHeader((Header)rseqHeader);
                AllowHeader allowHeader = this.headerFactory.createAllowHeader("UPDATE");
                response.addHeader((Header)allowHeader);
                lastTransaction.sendResponse(response);
            } else if (this.sdpParameters != null) {
                ContentTypeHeader responseCTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                response = this.messageFactory.createResponse(183, invite, responseCTypeHeader, (Object)this.sdpParameters);
                ToHeader responseToHeader = (ToHeader)response.getHeader("To");
                responseToHeader.setTag(Utils.generateTag());
                SipURI responseContactURI = this.addressFactory.createSipURI(this.localUserName, this.sipStack.getIPAddress());
                responseContactURI.setTransportParam("TCP");
                responseContactURI.setPort(this.sipProvider.getListeningPoint().getPort());
                Address responseContactAddress = this.addressFactory.createAddress(this.localUserDisplayName, (URI)responseContactURI);
                ContactHeader responseContactHeader = this.headerFactory.createContactHeader(responseContactAddress);
                response.addHeader((Header)responseContactHeader);
                response.addHeader((Header)requireHeader);
                RSeqHeader rseqHeader = this.headerFactory.createRSeqHeader(1);
                response.addHeader((Header)rseqHeader);
                AllowHeader allowHeader = this.headerFactory.createAllowHeader("UPDATE");
                response.addHeader((Header)allowHeader);
                lastTransaction.sendResponse(response);
            } else {
                response = this.messageFactory.createResponse(183, invite);
                ToHeader responseToHeader = (ToHeader)response.getHeader("To");
                responseToHeader.setTag(Utils.generateTag());
                SipURI responseContactURI = this.addressFactory.createSipURI(this.localUserName, this.sipStack.getIPAddress());
                responseContactURI.setTransportParam("TCP");
                responseContactURI.setPort(this.sipProvider.getListeningPoint().getPort());
                Address responseContactAddress = this.addressFactory.createAddress(this.localUserDisplayName, (URI)responseContactURI);
                ContactHeader responseContactHeader = this.headerFactory.createContactHeader(responseContactAddress);
                response.addHeader((Header)responseContactHeader);
                response.addHeader((Header)requireHeader);
                RSeqHeader rseqHeader = this.headerFactory.createRSeqHeader(1);
                response.addHeader((Header)rseqHeader);
                AllowHeader allowHeader = this.headerFactory.createAllowHeader("UPDATE");
                response.addHeader((Header)allowHeader);
                lastTransaction.sendResponse(response);
            }
            sessionData.setDialog(lastTransaction.getDialog());
            if (response != null) {
                System.out.println("Sent message:");
                System.out.println("-------------------------------------");
                System.out.println(response.toString());
                System.out.println("-------------------------------------");
            }
            return true;
        }
        catch (TransactionDoesNotExistException tdne) {
            System.out.println("Couldn't determine the invite request from the transactionId (or the corresponding response)!");
            tdne.printStackTrace();
            return false;
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            return false;
        }
        catch (SipException se) {
            se.printStackTrace();
            return false;
        }
    }

    protected SipProvider getSipProvider() {
        return this.sipProvider;
    }

    protected AddressFactory getAddressFactory() {
        return this.addressFactory;
    }

    protected MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    protected HeaderFactory getHeaderFactory() {
        return this.headerFactory;
    }

    public String getSdpParameters() {
        return this.sdpParameters;
    }

    public void sendPRACK(String finalSDP, ResponseEvent responseEvent) throws SipException {
        Response response = responseEvent.getResponse();
        SessionData sessionData = this.sessionDataMapping.getSessionData(((CallIdHeader)response.getHeader("Call-ID")).getCallId());
        if (sessionData == null) {
            throw new SipException("PRACK can only be sent after an initial request!");
        }
        if (sessionData.getDialog() == null) {
            throw new SipException("PRACK can only be sent after a reliable provisional response has been received!");
        }
        try {
            RouteHeader routeHeader;
            ContentTypeHeader contentTypeHeader;
            SipURI requestURI = (SipURI)sessionData.getRemoteAddress().getURI().clone();
            requestURI.setTransportParam("TCP");
            ToHeader toHeader = this.headerFactory.createToHeader(sessionData.getRemoteAddress(), sessionData.getDialog().getRemoteTag());
            FromHeader fromHeader = this.headerFactory.createFromHeader(sessionData.getLocalAddress(), sessionData.getDialog().getLocalTag());
            String transport = this.sipProvider.getListeningPoint().getTransport();
            ViaHeader viaHeader = this.headerFactory.createViaHeader(this.sipStack.getIPAddress(), this.sipProvider.getListeningPoint().getPort(), transport, Utils.generateBranchId());
            CallIdHeader callIdHeader = sessionData.getCallIdHeader();
            CSeqHeader cSeqHeader = this.headerFactory.createCSeqHeader(sessionData.getDialog().getLocalSequenceNumber() + 1, "PRACK");
            sessionData.getDialog().incrementLocalSequenceNumber();
            CSeqHeader cseqHeader = (CSeqHeader)response.getHeader("CSeq");
            String method = cseqHeader.getMethod();
            int Sequence = cseqHeader.getSequenceNumber();
            RSeqHeader rseqHeader = (RSeqHeader)response.getHeader("RSeq");
            int RSequence = rseqHeader.getSequenceNumber();
            RAckHeader rackHeader = this.headerFactory.createRAckHeader(RSequence, Sequence, method);
            ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
            viaHeaders.add(viaHeader);
            Request prack = this.messageFactory.createRequest((URI)requestURI, "PRACK", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, this.headerFactory.createMaxForwardsHeader(70));
            ContentLengthHeader contentLengthHeader = null;
            if (finalSDP != null) {
                contentLengthHeader = this.headerFactory.createContentLengthHeader(finalSDP.length());
                prack.setContentLength(contentLengthHeader);
                if (finalSDP.length() != 0) {
                    contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                    prack.setContent((Object)finalSDP, contentTypeHeader);
                }
            } else if (this.sdpParameters != null) {
                contentLengthHeader = this.headerFactory.createContentLengthHeader(this.sdpParameters.length());
                contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                prack.setContentLength(contentLengthHeader);
                prack.setContent((Object)this.sdpParameters, contentTypeHeader);
            }
            prack.addHeader((Header)rackHeader);
            if (contentLengthHeader != null) {
                prack.setContentLength(contentLengthHeader);
            } else {
                contentLengthHeader.setContentLength(0);
                prack.setContentLength(contentLengthHeader);
            }
            prack.addHeader((Header)contentLengthHeader);
            prack.removeHeader("Route");
            Request firstRequest = sessionData.getDialog().getFirstTransaction().getRequest();
            ListIterator recordRouteHeaders = firstRequest.getHeaders("Record-Route");
            ListIterator routeHeaders = firstRequest.getHeaders("Route");
            if (recordRouteHeaders != null) {
                while (recordRouteHeaders.hasNext()) {
                    routeHeader = this.headerFactory.createRouteHeader(((RecordRouteHeader)recordRouteHeaders.next()).getAddress());
                    prack.addHeader((Header)routeHeader);
                }
            }
            if (routeHeaders != null) {
                while (routeHeaders.hasNext()) {
                    routeHeader = this.headerFactory.createRouteHeader(((RouteHeader)routeHeaders.next()).getAddress());
                    prack.addHeader((Header)routeHeader);
                }
            }
            ClientTransaction prackTransaction = this.sipProvider.getNewClientTransaction(prack);
            prackTransaction.sendRequest();
            System.out.println("Sent message:");
            System.out.println("-------------------------------------");
            System.out.println(prack.toString());
            System.out.println("-------------------------------------");
        }
        catch (InvalidArgumentException iae) {
            iae.printStackTrace();
            throw new SipException("Invalid header value!");
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            throw new SipException("Invalid header value!");
        }
    }

    public void sendUpdate(String finalSDP, String sessionId) throws SipException {
        SessionData sessionData = this.sessionDataMapping.getSessionData(sessionId);
        try {
            RouteHeader routeHeader;
            ContentTypeHeader contentTypeHeader;
            SipURI requestURI = (SipURI)sessionData.getRemoteAddress().getURI().clone();
            requestURI.setTransportParam("TCP");
            ToHeader toHeader = this.headerFactory.createToHeader(sessionData.getRemoteAddress(), sessionData.getDialog().getRemoteTag());
            FromHeader fromHeader = this.headerFactory.createFromHeader(sessionData.getLocalAddress(), sessionData.getDialog().getLocalTag());
            String transport = this.sipProvider.getListeningPoint().getTransport();
            ViaHeader viaHeader = this.headerFactory.createViaHeader(this.sipStack.getIPAddress(), this.sipProvider.getListeningPoint().getPort(), transport, Utils.generateBranchId());
            CallIdHeader callIdHeader = sessionData.getCallIdHeader();
            CSeqHeader cSeqHeader = this.headerFactory.createCSeqHeader(sessionData.getDialog().getLocalSequenceNumber() + 1, "UPDATE");
            sessionData.getDialog().incrementLocalSequenceNumber();
            ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
            viaHeaders.add(viaHeader);
            Request update = this.messageFactory.createRequest((URI)requestURI, "UPDATE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, this.headerFactory.createMaxForwardsHeader(70));
            ContentLengthHeader contentLengthHeader = null;
            if (finalSDP != null) {
                contentLengthHeader = this.headerFactory.createContentLengthHeader(finalSDP.length());
                contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                update.setContentLength(contentLengthHeader);
                update.setContent((Object)finalSDP, contentTypeHeader);
            } else if (this.sdpParameters != null) {
                contentLengthHeader = this.headerFactory.createContentLengthHeader(this.sdpParameters.length());
                contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                update.setContentLength(contentLengthHeader);
                update.setContent((Object)finalSDP, contentTypeHeader);
            }
            if (contentLengthHeader != null) {
                update.setContentLength(contentLengthHeader);
            } else {
                contentLengthHeader.setContentLength(0);
                update.setContentLength(contentLengthHeader);
            }
            update.addHeader((Header)contentLengthHeader);
            update.removeHeader("Route");
            Request firstRequest = sessionData.getDialog().getFirstTransaction().getRequest();
            ListIterator recordRouteHeaders = firstRequest.getHeaders("Record-Route");
            ListIterator routeHeaders = firstRequest.getHeaders("Route");
            if (recordRouteHeaders != null) {
                while (recordRouteHeaders.hasNext()) {
                    routeHeader = this.headerFactory.createRouteHeader(((RecordRouteHeader)recordRouteHeaders.next()).getAddress());
                    update.addHeader((Header)routeHeader);
                }
            }
            if (routeHeaders != null) {
                while (routeHeaders.hasNext()) {
                    routeHeader = this.headerFactory.createRouteHeader(((RouteHeader)routeHeaders.next()).getAddress());
                    update.addHeader((Header)routeHeader);
                }
            }
            ClientTransaction updateTransaction = this.sipProvider.getNewClientTransaction(update);
            updateTransaction.sendRequest();
            System.out.println("Sent message:");
            System.out.println("-------------------------------------");
            System.out.println(update.toString());
            System.out.println("-------------------------------------");
        }
        catch (InvalidArgumentException iae) {
            iae.printStackTrace();
            throw new SipException("Invalid header value!");
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            throw new SipException("Invalid header value!");
        }
    }

    public boolean sendEmpty200OK(String sessionId) throws TransactionDoesNotExistException, ParseException, SipException {
        SessionData sessionData = this.sessionDataMapping.getSessionData(sessionId);
        try {
            if (sessionData == null) {
                return false;
            }
            ServerTransaction lastTransaction = (ServerTransaction)sessionData.getLastTransaction();
            Request request = lastTransaction.getRequest();
            Response response = this.messageFactory.createResponse(200, request);
            ToHeader responseToHeader = (ToHeader)response.getHeader("To");
            responseToHeader.setTag(Utils.generateTag());
            SipURI responseContactURI = this.addressFactory.createSipURI(this.localUserName, this.sipStack.getIPAddress());
            responseContactURI.setTransportParam("TCP");
            responseContactURI.setPort(this.sipProvider.getListeningPoint().getPort());
            Address responseContactAddress = this.addressFactory.createAddress(this.localUserDisplayName, (URI)responseContactURI);
            ContactHeader responseContactHeader = this.headerFactory.createContactHeader(responseContactAddress);
            response.addHeader((Header)responseContactHeader);
            AllowHeader allowHeader = this.headerFactory.createAllowHeader("UPDATE");
            response.addHeader((Header)allowHeader);
            lastTransaction.sendResponse(response);
            sessionData.setDialog(lastTransaction.getDialog());
            if (response != null) {
                System.out.println("Sent message:");
                System.out.println("-------------------------------------");
                System.out.println(response.toString());
                System.out.println("-------------------------------------");
            }
            return true;
        }
        catch (TransactionDoesNotExistException tdne) {
            System.out.println("Couldn't determine the request from the transactionId (or the corresponding response)!");
            tdne.printStackTrace();
            return false;
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            return false;
        }
        catch (SipException se) {
            se.printStackTrace();
            return false;
        }
    }

    public SIPUserAgentServer getSipUserAgentServer() {
        return this.sipUserAgentServer;
    }

    public SessionMapping getSessionDataMapping() {
        return this.sessionDataMapping;
    }
}

