/*
 * Decompiled with CFR 0.152.
 */
package hr.fer.tel.nims.dsa.server.sipagent;

import hr.fer.tel.nims.dsa.server.profilehandling.ProfileManager;
import java.io.IOException;
import javax.sip.Dialog;
import javax.sip.Transaction;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.header.CallIdHeader;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SessionData {
    private Address localAddress;
    private Address remoteAddress;
    private CallIdHeader callIdHeader;
    private Transaction lastTransaction;
    private boolean isSessionActive = false;
    private boolean isLocallyInitiated;
    private Dialog dialog;
    public static final int STARTED = 0;
    public static final int IDLE = 1;
    public static final int CHANGING_SERVICE_OCCURRED = 2;
    public static final int CHANGING_RESOURCE_OCCURRED = 3;
    public static final int CHANGING_CLIENT_OCCURRED = 4;
    private int state = 0;
    private int previousState = 0;
    private boolean OKInviteSent = false;
    private Document finalProfile;

    public SessionData(Address localAddress, Address remoteAddress, CallIdHeader callIdHeader, Transaction lastTransaction, boolean locallyInitiated) {
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.lastTransaction = lastTransaction;
        this.callIdHeader = callIdHeader;
        this.isLocallyInitiated = locallyInitiated;
    }

    public String getRemoteUser() {
        SipURI sipURI = (SipURI)this.remoteAddress.getURI();
        return sipURI.getUser();
    }

    public String getRemoteHost() {
        SipURI sipURI = (SipURI)this.remoteAddress.getURI();
        return sipURI.getHost();
    }

    public int getRemotePort() {
        SipURI sipURI = (SipURI)this.remoteAddress.getURI();
        return sipURI.getPort();
    }

    public String getCallId() {
        return this.callIdHeader.getCallId();
    }

    public CallIdHeader getCallIdHeader() {
        return this.callIdHeader;
    }

    public Transaction getLastTransaction() {
        return this.lastTransaction;
    }

    public void setLastTransaction(Transaction lastTransaction) {
        this.lastTransaction = lastTransaction;
    }

    public boolean isSessionActive() {
        return this.isSessionActive;
    }

    public void setActive(boolean active) {
        this.isSessionActive = active;
    }

    public boolean isLocallyInitiated() {
        return this.isLocallyInitiated;
    }

    public String getRemoteUserDisplayName() {
        return this.remoteAddress.getDisplayName();
    }

    public Dialog getDialog() {
        return this.dialog;
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
    }

    public String getLocalUser() {
        SipURI sipURI = (SipURI)this.localAddress.getURI();
        return sipURI.getUser();
    }

    public String getLocalUserDisplayName() {
        return this.localAddress.getDisplayName();
    }

    public Address getRemoteAddress() {
        return this.remoteAddress;
    }

    public Address getLocalAddress() {
        return this.localAddress;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getPreviousState() {
        return this.previousState;
    }

    public void setPreviousState(int previousState) {
        this.previousState = previousState;
    }

    public void setOKInviteSent(boolean is) {
        this.OKInviteSent = is;
    }

    public boolean getOKInviteSent() {
        return this.OKInviteSent;
    }

    public Document getFinalProfile() {
        return this.finalProfile;
    }

    void setFinalProfile(String profile) {
        if (profile == null) {
            this.finalProfile = null;
        } else {
            try {
                this.finalProfile = new ProfileManager().getDocumentFromString(profile);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (SAXException saxe) {
                saxe.printStackTrace();
            }
        }
    }
}

