/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.core.NameValue;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.header.AddressParametersHeader;
import gov.nist.javax.sip.header.ContactList;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.address.Address;
import javax.sip.header.ContactHeader;

public final class Contact
extends AddressParametersHeader
implements ContactHeader {
    public static final String ACTION = "action";
    public static final String PROXY = "proxy";
    public static final String REDIRECT = "redirect";
    public static final String EXPIRES = "expires";
    public static final String Q = "q";
    private ContactList contactList;
    protected boolean wildCardFlag;

    public Contact() {
        super("Contact");
    }

    public void setParameter(String string, String string2) throws ParseException {
        NameValue nameValue = this.parameters.getNameValue(string);
        if (nameValue != null) {
            nameValue.setValue(string2);
        } else {
            nameValue = new NameValue(string, string2);
            if (string.equalsIgnoreCase("methods")) {
                nameValue.setQuotedValue();
            }
            this.parameters.set(nameValue);
        }
    }

    protected String encodeBody() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.wildCardFlag) {
            return stringBuffer.append("*").toString();
        }
        if (this.address.getAddressType() == 1) {
            stringBuffer.append(this.address.encode());
        } else {
            stringBuffer.append("<").append(this.address.encode()).append(">");
        }
        if (!this.parameters.isEmpty()) {
            stringBuffer.append(";").append(this.parameters.encode());
        }
        return stringBuffer.toString();
    }

    public ContactList getContactList() {
        return this.contactList;
    }

    public boolean getWildCardFlag() {
        return this.wildCardFlag;
    }

    public Address getAddress() {
        return this.address;
    }

    public NameValueList getContactParms() {
        return this.parameters;
    }

    public int getExpires() {
        return this.getParameterAsInt(EXPIRES);
    }

    public void setExpires(int n) {
        Integer n2 = new Integer(n);
        this.parameters.set(EXPIRES, n2);
    }

    public float getQValue() {
        return this.getParameterAsFloat(Q);
    }

    public void setContactList(ContactList contactList) {
        this.contactList = contactList;
    }

    public void setWildCardFlag(boolean bl) {
        this.wildCardFlag = true;
        this.address = new AddressImpl();
        this.address.setWildCardFlag();
    }

    public void setAddress(Address address) {
        if (address == null) {
            throw new NullPointerException("null address");
        }
        this.address = (AddressImpl)address;
        this.wildCardFlag = false;
    }

    public void setQValue(float f) throws InvalidArgumentException {
        if (f != -1.0f && (f < 0.0f || f > 1.0f)) {
            throw new InvalidArgumentException("JAIN-SIP Exception, Contact, setQValue(), the qValue is not between 0 and 1");
        }
        this.parameters.set(Q, new Float(f));
    }

    public boolean equals(Object object) {
        if (object.getClass() != this.getClass()) {
            return false;
        }
        Contact contact = (Contact)object;
        if (this.wildCardFlag != contact.wildCardFlag) {
            return false;
        }
        if (this.wildCardFlag == contact.wildCardFlag) {
            return true;
        }
        return super.equals(object);
    }

    public Object clone() {
        Contact contact = (Contact)super.clone();
        if (this.contactList != null) {
            contact.contactList = (ContactList)this.contactList.clone();
        }
        return contact;
    }
}

