/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.SIPObject;

public final class StatusLine
extends SIPObject {
    protected boolean matchStatusClass;
    protected String sipVersion = "SIP/2.0";
    protected int statusCode;
    protected String reasonPhrase = null;

    public boolean match(Object object) {
        if (!(object instanceof StatusLine)) {
            return false;
        }
        StatusLine statusLine = (StatusLine)object;
        if (statusLine.matchExpression != null) {
            return statusLine.matchExpression.match(this.encode());
        }
        if (statusLine.sipVersion != null && !statusLine.sipVersion.equals(this.sipVersion)) {
            return false;
        }
        if (statusLine.statusCode != 0) {
            if (this.matchStatusClass) {
                int n = statusLine.statusCode;
                String string = new Integer(statusLine.statusCode).toString();
                String string2 = new Integer(this.statusCode).toString();
                if (string.charAt(0) != string2.charAt(0)) {
                    return false;
                }
            } else if (this.statusCode != statusLine.statusCode) {
                return false;
            }
        }
        if (statusLine.reasonPhrase == null || this.reasonPhrase == statusLine.reasonPhrase) {
            return true;
        }
        return this.reasonPhrase.equals(statusLine.reasonPhrase);
    }

    public void setMatchStatusClass(boolean bl) {
        this.matchStatusClass = bl;
    }

    public String encode() {
        String string = "SIP/2.0 " + this.statusCode;
        if (this.reasonPhrase != null) {
            string = string + " " + this.reasonPhrase;
        }
        string = string + "\r\n";
        return string;
    }

    public String getSipVersion() {
        return this.sipVersion;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public void setSipVersion(String string) {
        this.sipVersion = string;
    }

    public void setStatusCode(int n) {
        this.statusCode = n;
    }

    public void setReasonPhrase(String string) {
        this.reasonPhrase = string;
    }

    public String getVersionMajor() {
        if (this.sipVersion == null) {
            return null;
        }
        String string = null;
        boolean bl = false;
        for (int i = 0; i < this.sipVersion.length(); ++i) {
            if (this.sipVersion.charAt(i) == '.') {
                bl = false;
            }
            if (bl) {
                string = string == null ? "" + this.sipVersion.charAt(i) : string + this.sipVersion.charAt(i);
            }
            if (this.sipVersion.charAt(i) != '/') continue;
            bl = true;
        }
        return string;
    }

    public String getVersionMinor() {
        if (this.sipVersion == null) {
            return null;
        }
        String string = null;
        boolean bl = false;
        for (int i = 0; i < this.sipVersion.length(); ++i) {
            if (bl) {
                string = string == null ? "" + this.sipVersion.charAt(i) : string + this.sipVersion.charAt(i);
            }
            if (this.sipVersion.charAt(i) != '.') continue;
            bl = true;
        }
        return string;
    }
}

