/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.LogWriter;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.stack.HopImpl;
import gov.nist.javax.sip.stack.SIPMessageStack;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.sip.ListeningPoint;
import javax.sip.SipStack;
import javax.sip.address.Hop;
import javax.sip.address.Router;
import javax.sip.address.SipURI;
import javax.sip.message.Request;

public class DefaultRouter
implements Router {
    protected SIPMessageStack sipStack;
    protected HopImpl defaultRoute;

    public DefaultRouter(SipStack sipStack, String string) {
        this.sipStack = (SIPMessageStack)sipStack;
        if (string != null) {
            this.defaultRoute = new HopImpl(string);
        }
    }

    public DefaultRouter(SIPMessageStack sIPMessageStack, String string) {
        this.sipStack = sIPMessageStack;
        if (string != null) {
            this.defaultRoute = new HopImpl(string);
        }
    }

    private boolean hopsBackToMe(String string, int n) {
        Iterator iterator = ((SipStackImpl)this.sipStack).getListeningPoints();
        while (iterator.hasNext()) {
            ListeningPoint listeningPoint = (ListeningPoint)iterator.next();
            if (!((SipStackImpl)this.sipStack).getIPAddress().equalsIgnoreCase(string) || listeningPoint.getPort() != n) continue;
            return true;
        }
        return false;
    }

    public ListIterator getNextHops(Request request) {
        SIPRequest sIPRequest = (SIPRequest)request;
        RequestLine requestLine = sIPRequest.getRequestLine();
        if (requestLine == null) {
            throw new IllegalArgumentException("Bad message");
        }
        GenericURI genericURI = requestLine.getUri();
        if (genericURI == null) {
            throw new IllegalArgumentException("Bad message: Null requestURI");
        }
        LinkedList<HopImpl> linkedList = null;
        RouteList routeList = sIPRequest.getRouteHeaders();
        if (routeList != null) {
            int n;
            linkedList = new LinkedList<HopImpl>();
            Route route = (Route)routeList.getFirst();
            SipUri sipUri = (SipUri)route.getAddress().getURI();
            if (sipUri.getHostPort().hasPort()) {
                this.sipStack.logWriter.logMessage("routeHeader = " + sipUri.encode());
                this.sipStack.logWriter.logMessage("port = " + sipUri.getHostPort().getPort());
                n = sipUri.getHostPort().getPort();
            } else {
                n = 5060;
            }
            String string = sipUri.getHost();
            String string2 = sipUri.getTransportParam();
            if (string2 == null) {
                string2 = "udp";
            }
            HopImpl hopImpl = new HopImpl(string, n, string2);
            linkedList.add(hopImpl);
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("We use the Route header to forward the message");
            }
        } else if (genericURI instanceof SipURI && ((SipURI)genericURI).getMAddrParam() != null) {
            String string = ((SipURI)genericURI).getMAddrParam();
            String string3 = ((SipURI)genericURI).getTransportParam();
            if (string3 == null) {
                string3 = "udp";
            }
            int n = 5060;
            HopImpl hopImpl = new HopImpl(string, n, string3);
            hopImpl.setURIRouteFlag();
            linkedList = new LinkedList();
            linkedList.add(hopImpl);
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("Added Hop = " + hopImpl.toString());
            }
        } else if (genericURI instanceof SipURI) {
            String string = ((SipURI)genericURI).getHost();
            int n = ((SipURI)genericURI).getPort();
            if (n == -1) {
                n = 5060;
            }
            if (this.hopsBackToMe(string, n)) {
                return null;
            }
            String string4 = ((SipURI)genericURI).getTransportParam();
            if (string4 == null) {
                string4 = "udp";
            }
            HopImpl hopImpl = new HopImpl(string, n, string4);
            linkedList = new LinkedList();
            linkedList.add(hopImpl);
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("Added Hop = " + hopImpl.toString());
            }
        }
        if (this.defaultRoute != null) {
            if (linkedList == null) {
                linkedList = new LinkedList();
            }
            linkedList.add(this.defaultRoute);
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("Added Hop = " + this.defaultRoute.toString());
            }
        }
        return linkedList == null ? null : linkedList.listIterator();
    }

    public Hop getOutboundProxy() {
        return this.defaultRoute;
    }

    public Hop getDefaultRoute() {
        return this.defaultRoute;
    }
}

