/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.LogWriter;
import gov.nist.core.net.DefaultNetworkLayer;
import gov.nist.core.net.NetworkLayer;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.IOHandler;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.ServerLog;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.StackMessageFactory;
import gov.nist.javax.sip.stack.TCPMessageProcessor;
import gov.nist.javax.sip.stack.TLSMessageProcessor;
import gov.nist.javax.sip.stack.UDPMessageProcessor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.sip.address.Hop;
import javax.sip.address.Router;
import javax.sip.message.Request;

public abstract class SIPMessageStack {
    protected LogWriter logWriter;
    protected ServerLog serverLog;
    protected boolean tcpFlag;
    protected boolean udpFlag;
    protected boolean tlsFlag;
    protected IOHandler ioHandler;
    protected boolean toExit = false;
    protected String badMessageLog;
    protected boolean debugFlag;
    protected String stackName;
    protected String stackAddress;
    protected InetAddress stackInetAddress;
    protected String savedStackAddress;
    protected InetAddress savedStackInetAddress;
    protected StackMessageFactory sipMessageFactory;
    public static final int DEFAULT_PORT = 5060;
    protected Router router;
    protected int threadPoolSize = -1;
    protected int maxConnections = -1;
    protected boolean cacheServerConnections = true;
    protected boolean cacheClientConnections = true;
    protected int maxContentLength;
    protected int maxMessageSize;
    private Collection messageProcessors = new ArrayList();
    protected String stunServerAddress;
    protected int stunServerPort;
    protected int readTimeout = -1;
    protected NetworkLayer networkLayer;

    public NetworkLayer getNetworkLayer() {
        if (this.networkLayer == null) {
            return DefaultNetworkLayer.SINGLETON;
        }
        return this.networkLayer;
    }

    public void logBadMessage(String string) {
        if (this.badMessageLog != null) {
            this.logWriter.logMessage(string, this.badMessageLog);
        }
    }

    public void logMessage(String string) {
        this.logWriter.logMessage(string);
    }

    public LogWriter getLogWriter() {
        return this.logWriter;
    }

    public ServerLog getServerLog() {
        return this.serverLog;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void logStackTrace() {
        this.logWriter.logStackTrace();
    }

    public String getBadMessageLog() {
        return this.badMessageLog;
    }

    public void setSingleThreaded() {
        this.threadPoolSize = 1;
    }

    public void setThreadPoolSize(int n) {
        this.threadPoolSize = n;
    }

    public void setMaxConnections(int n) {
        this.maxConnections = n;
    }

    public Iterator getNextHop(SIPRequest sIPRequest) {
        return this.router.getNextHops((Request)sIPRequest);
    }

    public SIPMessageStack(StackMessageFactory stackMessageFactory, String string, String string2) throws UnknownHostException {
        this();
        this.sipMessageFactory = stackMessageFactory;
        if (string == null) {
            throw new UnknownHostException("stack Address not set");
        }
        this.stackInetAddress = InetAddress.getByName(string);
    }

    public void setStackMessageFactory(StackMessageFactory stackMessageFactory) {
        this.sipMessageFactory = stackMessageFactory;
    }

    public void setStackName(String string) {
        this.stackName = string;
    }

    public String getStackName() {
        return this.stackName;
    }

    protected void setHostAddress(String string) throws UnknownHostException {
        this.stackAddress = string.indexOf(58) != string.lastIndexOf(58) && string.trim().charAt(0) != '[' ? '[' + string + ']' : string;
        this.stackInetAddress = InetAddress.getByName(string);
    }

    protected void setRealHostAddress(String string) throws UnknownHostException {
        this.savedStackAddress = string.indexOf(58) != string.lastIndexOf(58) && string.trim().charAt(0) != '[' ? '[' + string + ']' : string;
        this.savedStackInetAddress = InetAddress.getByName(string);
    }

    protected InetAddress getRealIPAddress() {
        return this.savedStackInetAddress;
    }

    public String getHostAddress() {
        return this.stackAddress;
    }

    public Hop getNextHop() {
        return this.router.getOutboundProxy();
    }

    public int getPort(String string) {
        Collection collection = this.messageProcessors;
        synchronized (collection) {
            Iterator iterator = this.messageProcessors.iterator();
            while (iterator.hasNext()) {
                MessageProcessor messageProcessor = (MessageProcessor)iterator.next();
                if (!messageProcessor.getTransport().equalsIgnoreCase(string)) continue;
                return messageProcessor.getPort();
            }
            throw new IllegalArgumentException("Transport not supported " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTransportEnabled(String string) {
        Collection collection = this.messageProcessors;
        synchronized (collection) {
            Iterator iterator = this.messageProcessors.iterator();
            while (iterator.hasNext()) {
                MessageProcessor messageProcessor = (MessageProcessor)iterator.next();
                if (!messageProcessor.getTransport().equalsIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTransportEnabled(String string, int n) {
        Collection collection = this.messageProcessors;
        synchronized (collection) {
            Iterator iterator = this.messageProcessors.iterator();
            while (iterator.hasNext()) {
                MessageProcessor messageProcessor = (MessageProcessor)iterator.next();
                if (!messageProcessor.getTransport().equalsIgnoreCase(string) || messageProcessor.getPort() != n) continue;
                return true;
            }
            return false;
        }
    }

    protected void reInit() {
        if (LogWriter.needsLogging) {
            this.logWriter.logMessage("Re-initializing !");
        }
        this.messageProcessors = new ArrayList();
        this.ioHandler = new IOHandler(this);
    }

    public SIPMessageStack() {
        this.ioHandler = new IOHandler(this);
        this.logWriter = new LogWriter();
        this.serverLog = new ServerLog(this);
    }

    protected void setDebugLogFileName(String string) {
        this.logWriter.setLogFileName(string);
    }

    protected ServerRequestInterface newSIPServerRequest(SIPRequest sIPRequest, MessageChannel messageChannel) {
        return this.sipMessageFactory.newSIPServerRequest(sIPRequest, messageChannel);
    }

    protected ServerResponseInterface newSIPServerResponse(SIPResponse sIPResponse, MessageChannel messageChannel) {
        return this.sipMessageFactory.newSIPServerResponse(sIPResponse, messageChannel);
    }

    public void setRouter(Router router) {
        this.router = router;
    }

    public Router getRouter() {
        return this.router;
    }

    public Hop getDefaultRoute() {
        return this.router.getOutboundProxy();
    }

    public Route getRouteHeader(Hop hop) {
        HostPort hostPort = new HostPort();
        Host host = new Host(hop.getHost());
        hostPort.setHost(host);
        hostPort.setPort(hop.getPort());
        SipUri sipUri = new SipUri();
        sipUri.setHostPort(hostPort);
        sipUri.setScheme("sip");
        try {
            sipUri.setTransportParam(hop.getTransport());
        }
        catch (ParseException parseException) {
            InternalErrorHandler.handleException(parseException);
        }
        AddressImpl addressImpl = new AddressImpl();
        addressImpl.setURI(sipUri);
        Route route = new Route();
        route.setAddress(addressImpl);
        return route;
    }

    public Route getDefaultRouteHeader() {
        if (this.router.getOutboundProxy() != null) {
            Hop hop = this.router.getOutboundProxy();
            return this.getRouteHeader(hop);
        }
        return null;
    }

    public boolean isAlive() {
        return !this.toExit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopStack() {
        this.toExit = true;
        Object object = this;
        synchronized (object) {
            this.notifyAll();
        }
        object = this.messageProcessors;
        synchronized (object) {
            MessageProcessor[] messageProcessorArray = this.getMessageProcessors();
            for (int i = 0; i < messageProcessorArray.length; ++i) {
                this.removeMessageProcessor(messageProcessorArray[i]);
            }
            this.ioHandler.closeAll();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageProcessor(MessageProcessor messageProcessor) throws IOException {
        Collection collection = this.messageProcessors;
        synchronized (collection) {
            messageProcessor.start();
            this.messageProcessors.add(messageProcessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageProcessor(MessageProcessor messageProcessor) {
        Collection collection = this.messageProcessors;
        synchronized (collection) {
            if (this.messageProcessors.remove(messageProcessor)) {
                messageProcessor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageProcessor[] getMessageProcessors() {
        Collection collection = this.messageProcessors;
        synchronized (collection) {
            return this.messageProcessors.toArray(new MessageProcessor[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageProcessor getMessageProcessor(String string) {
        Collection collection = this.messageProcessors;
        synchronized (collection) {
            Iterator iterator = this.messageProcessors.iterator();
            while (iterator.hasNext()) {
                MessageProcessor messageProcessor = (MessageProcessor)iterator.next();
                if (!messageProcessor.getTransport().equalsIgnoreCase(string)) continue;
                return messageProcessor;
            }
            return null;
        }
    }

    public MessageProcessor createMessageProcessor(int n, String string) throws IOException {
        if (string.equalsIgnoreCase("udp")) {
            UDPMessageProcessor uDPMessageProcessor = new UDPMessageProcessor(this, n);
            this.addMessageProcessor(uDPMessageProcessor);
            this.udpFlag = true;
            return uDPMessageProcessor;
        }
        if (string.equalsIgnoreCase("tcp")) {
            TCPMessageProcessor tCPMessageProcessor = new TCPMessageProcessor(this, n);
            this.addMessageProcessor(tCPMessageProcessor);
            this.tcpFlag = true;
            return tCPMessageProcessor;
        }
        if (string.equalsIgnoreCase("tls")) {
            TLSMessageProcessor tLSMessageProcessor = new TLSMessageProcessor(this, n);
            this.addMessageProcessor(tLSMessageProcessor);
            this.tlsFlag = true;
            return tLSMessageProcessor;
        }
        throw new IllegalArgumentException("bad transport");
    }

    protected void setMessageFactory(StackMessageFactory stackMessageFactory) {
        this.sipMessageFactory = stackMessageFactory;
    }

    public MessageChannel createMessageChannel(int n, Hop hop) throws UnknownHostException {
        Host host = new Host();
        host.setHostname(hop.getHost());
        HostPort hostPort = new HostPort();
        hostPort.setHost(host);
        hostPort.setPort(hop.getPort());
        MessageChannel messageChannel = null;
        Iterator iterator = this.messageProcessors.iterator();
        while (iterator.hasNext() && messageChannel == null) {
            MessageProcessor messageProcessor = (MessageProcessor)iterator.next();
            if (!hop.getTransport().equalsIgnoreCase(messageProcessor.getTransport()) || n != messageProcessor.getPort()) continue;
            try {
                messageChannel = messageProcessor.createMessageChannel(hostPort);
            }
            catch (UnknownHostException unknownHostException) {
                if (LogWriter.needsLogging) {
                    this.logWriter.logException(unknownHostException);
                }
                throw unknownHostException;
            }
            catch (IOException iOException) {
                if (!LogWriter.needsLogging) continue;
                this.logWriter.logException(iOException);
            }
        }
        return messageChannel;
    }
}

