/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.InternalErrorHandler;
import gov.nist.core.LogWriter;
import gov.nist.javax.sip.header.ParametersHeader;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.parser.ParseExceptionListener;
import gov.nist.javax.sip.parser.StringMsgParser;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPMessageStack;
import gov.nist.javax.sip.stack.UDPMessageProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.LinkedList;

public class UDPMessageChannel
extends MessageChannel
implements ParseExceptionListener,
Runnable {
    protected SIPMessageStack stack;
    protected StringMsgParser myParser;
    private InetAddress peerAddress;
    private String myAddress;
    private int peerPacketSourcePort;
    private InetAddress peerPacketSourceAddress;
    private int peerPort;
    private String peerProtocol;
    protected int myPort;
    private byte[] msgBytes;
    private DatagramPacket incomingPacket;
    private long receptionTime;
    static /* synthetic */ Class class$gov$nist$javax$sip$header$From;
    static /* synthetic */ Class class$gov$nist$javax$sip$header$To;
    static /* synthetic */ Class class$gov$nist$javax$sip$header$CSeq;
    static /* synthetic */ Class class$gov$nist$javax$sip$header$Via;
    static /* synthetic */ Class class$gov$nist$javax$sip$header$CallID;
    static /* synthetic */ Class class$gov$nist$javax$sip$header$RequestLine;
    static /* synthetic */ Class class$gov$nist$javax$sip$header$StatusLine;

    protected UDPMessageChannel(SIPMessageStack sIPMessageStack, UDPMessageProcessor uDPMessageProcessor) {
        this.messageProcessor = uDPMessageProcessor;
        this.stack = sIPMessageStack;
        Thread thread = new Thread(this);
        this.myAddress = sIPMessageStack.getHostAddress();
        this.myPort = uDPMessageProcessor.getPort();
        thread.setName("UDPMessageChannelThread");
        thread.setDaemon(true);
        thread.start();
    }

    protected UDPMessageChannel(SIPMessageStack sIPMessageStack, UDPMessageProcessor uDPMessageProcessor, DatagramPacket datagramPacket) {
        this.incomingPacket = datagramPacket;
        this.messageProcessor = uDPMessageProcessor;
        this.stack = sIPMessageStack;
        this.myAddress = sIPMessageStack.getHostAddress();
        this.myPort = uDPMessageProcessor.getPort();
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    protected UDPMessageChannel(InetAddress inetAddress, int n, SIPMessageStack sIPMessageStack, UDPMessageProcessor uDPMessageProcessor) {
        this.peerAddress = inetAddress;
        this.peerPort = n;
        this.peerProtocol = "UDP";
        this.messageProcessor = uDPMessageProcessor;
        this.myAddress = sIPMessageStack.getHostAddress();
        this.myPort = uDPMessageProcessor.getPort();
        this.stack = sIPMessageStack;
        if (LogWriter.needsLogging) {
            this.stack.logWriter.logMessage("Creating message channel " + inetAddress.getHostAddress() + "/" + n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Object object;
            Object object2;
            String string;
            DatagramPacket datagramPacket;
            if (this.myParser == null) {
                this.myParser = new StringMsgParser();
                this.myParser.setParseExceptionListener(this);
            }
            if (this.stack.threadPoolSize != -1) {
                LinkedList linkedList = ((UDPMessageProcessor)this.messageProcessor).messageQueue;
                synchronized (linkedList) {
                    while (((UDPMessageProcessor)this.messageProcessor).messageQueue.isEmpty()) {
                        if (!((UDPMessageProcessor)this.messageProcessor).isRunning) {
                            return;
                        }
                        try {
                            ((UDPMessageProcessor)this.messageProcessor).messageQueue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            if (((UDPMessageProcessor)this.messageProcessor).isRunning) continue;
                            return;
                        }
                    }
                    datagramPacket = (DatagramPacket)((UDPMessageProcessor)this.messageProcessor).messageQueue.removeFirst();
                }
                this.incomingPacket = datagramPacket;
            } else {
                datagramPacket = this.incomingPacket;
            }
            this.peerAddress = datagramPacket.getAddress();
            int n = datagramPacket.getLength();
            byte[] byArray = datagramPacket.getData();
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            if (LogWriter.needsLogging) {
                this.stack.logWriter.logMessage("UDPMessageChannel: peerAddress = " + this.peerAddress.getHostAddress() + "/" + datagramPacket.getPort());
                this.stack.logWriter.logMessage("Length = " + n);
                string = new String(byArray2, 0, n);
                this.stack.logWriter.logMessage(string);
            }
            string = null;
            SIPMessage sIPMessage = null;
            try {
                this.receptionTime = System.currentTimeMillis();
                sIPMessage = this.myParser.parseSIPMessage(byArray2);
                this.myParser = null;
            }
            catch (ParseException parseException) {
                this.myParser = null;
                if (LogWriter.needsLogging) {
                    this.stack.logWriter.logMessage("Rejecting message !  " + new String(byArray2));
                    this.stack.logWriter.logMessage("error message " + parseException.getMessage());
                    this.stack.logWriter.logException(parseException);
                }
                this.stack.logBadMessage(new String(byArray2));
                if (this.stack.threadPoolSize != -1) continue;
                return;
            }
            if (sIPMessage == null) {
                if (LogWriter.needsLogging) {
                    this.stack.logWriter.logMessage("Rejecting message !  " + new String(byArray2));
                    this.stack.logWriter.logMessage("Null message parsed.");
                }
                if (this.stack.threadPoolSize != -1) continue;
                return;
            }
            ViaList viaList = sIPMessage.getViaHeaders();
            if (sIPMessage.getFrom() == null || sIPMessage.getTo() == null || sIPMessage.getCallId() == null || sIPMessage.getCSeq() == null || sIPMessage.getViaHeaders() == null) {
                object2 = new String(byArray2);
                if (LogWriter.needsLogging) {
                    this.stack.logWriter.logMessage("bad message " + (String)object2);
                    this.stack.logWriter.logMessage(">>> Dropped Bad Msg From = " + sIPMessage.getFrom() + "To = " + sIPMessage.getTo() + "CallId = " + sIPMessage.getCallId() + "CSeq = " + sIPMessage.getCSeq() + "Via = " + sIPMessage.getViaHeaders());
                }
                this.stack.logBadMessage((String)object2);
                if (this.stack.threadPoolSize != -1) continue;
                return;
            }
            if (sIPMessage instanceof SIPRequest) {
                object2 = (Via)viaList.first();
                if (((Via)object2).hasPort()) {
                    if (sIPMessage instanceof SIPRequest) {
                        this.peerPort = ((Via)object2).getPort();
                    }
                } else {
                    this.peerPort = 5060;
                }
                this.peerProtocol = ((Via)object2).getTransport();
                this.peerPacketSourceAddress = datagramPacket.getAddress();
                this.peerPacketSourcePort = datagramPacket.getPort();
                try {
                    this.peerAddress = datagramPacket.getAddress();
                    if (!((Via)object2).getSentBy().getInetAddress().equals(this.peerAddress)) {
                        ((ParametersHeader)object2).setParameter("received", this.peerAddress.getHostName());
                        ((ParametersHeader)object2).setParameter("rport", new Integer(this.peerPacketSourcePort).toString());
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    if (this.stack.serverLog.needsLogging(16)) {
                        this.stack.serverLog.logMessage(sIPMessage, this.getViaHost() + ":" + this.getViaPort(), this.stack.getHostAddress() + ":" + this.stack.getPort(this.getTransport()), "Dropped -- Could not resolve VIA header address!", false);
                    }
                    if (!LogWriter.needsLogging) continue;
                    this.stack.logWriter.logMessage("Rejecting message -- could not resolve Via Address");
                    continue;
                }
                catch (ParseException parseException) {
                    InternalErrorHandler.handleException(parseException);
                }
            }
            if (sIPMessage instanceof SIPRequest) {
                object2 = (SIPRequest)sIPMessage;
                object = this.stack.newSIPServerRequest((SIPRequest)object2, this);
                if (object == null) {
                    if (!LogWriter.needsLogging) continue;
                    this.stack.logWriter.logMessage("Null request interface returned");
                    continue;
                }
                if (LogWriter.needsLogging) {
                    this.stack.logWriter.logMessage("About to process " + ((SIPRequest)object2).getFirstLine() + "/" + object);
                }
                object.processRequest((SIPRequest)object2, this);
                if (LogWriter.needsLogging) {
                    this.stack.logWriter.logMessage("Done processing " + ((SIPRequest)object2).getFirstLine() + "/" + object);
                }
                if (this.stack.serverLog.needsLogging(16)) {
                    if (object.getProcessingInfo() == null) {
                        this.stack.serverLog.logMessage(sIPMessage, ((SIPRequest)object2).getViaHost() + ":" + ((SIPRequest)object2).getViaPort(), this.stack.getHostAddress() + ":" + this.myPort, false, new Long(this.receptionTime).toString());
                    } else {
                        this.stack.serverLog.logMessage(sIPMessage, ((SIPRequest)object2).getViaHost() + ":" + ((SIPRequest)object2).getViaPort(), this.stack.getHostAddress() + ":" + this.myPort, object.getProcessingInfo(), false, new Long(this.receptionTime).toString());
                    }
                }
            } else {
                object2 = (SIPResponse)sIPMessage;
                object = this.stack.newSIPServerResponse((SIPResponse)object2, this);
                if (object != null) {
                    object.processResponse((SIPResponse)object2, this);
                } else if (LogWriter.needsLogging) {
                    this.stack.logWriter.logMessage("null sipServerResponse!");
                }
            }
            if (this.stack.threadPoolSize == -1) break;
        }
    }

    public void handleException(ParseException parseException, SIPMessage sIPMessage, Class clazz, String string, String string2) throws ParseException {
        if (LogWriter.needsLogging) {
            this.stack.logWriter.logException(parseException);
        }
        if (clazz != null && (clazz.equals(class$gov$nist$javax$sip$header$From == null ? (class$gov$nist$javax$sip$header$From = UDPMessageChannel.class$("gov.nist.javax.sip.header.From")) : class$gov$nist$javax$sip$header$From) || clazz.equals(class$gov$nist$javax$sip$header$To == null ? (class$gov$nist$javax$sip$header$To = UDPMessageChannel.class$("gov.nist.javax.sip.header.To")) : class$gov$nist$javax$sip$header$To) || clazz.equals(class$gov$nist$javax$sip$header$CSeq == null ? (class$gov$nist$javax$sip$header$CSeq = UDPMessageChannel.class$("gov.nist.javax.sip.header.CSeq")) : class$gov$nist$javax$sip$header$CSeq) || clazz.equals(class$gov$nist$javax$sip$header$Via == null ? (class$gov$nist$javax$sip$header$Via = UDPMessageChannel.class$("gov.nist.javax.sip.header.Via")) : class$gov$nist$javax$sip$header$Via) || clazz.equals(class$gov$nist$javax$sip$header$CallID == null ? (class$gov$nist$javax$sip$header$CallID = UDPMessageChannel.class$("gov.nist.javax.sip.header.CallID")) : class$gov$nist$javax$sip$header$CallID) || clazz.equals(class$gov$nist$javax$sip$header$RequestLine == null ? (class$gov$nist$javax$sip$header$RequestLine = UDPMessageChannel.class$("gov.nist.javax.sip.header.RequestLine")) : class$gov$nist$javax$sip$header$RequestLine) || clazz.equals(class$gov$nist$javax$sip$header$StatusLine == null ? (class$gov$nist$javax$sip$header$StatusLine = UDPMessageChannel.class$("gov.nist.javax.sip.header.StatusLine")) : class$gov$nist$javax$sip$header$StatusLine))) {
            this.stack.logBadMessage(string2);
            throw parseException;
        }
        sIPMessage.addUnparsed(string);
    }

    public void sendMessage(SIPMessage sIPMessage) throws IOException {
        if (LogWriter.needsLogging) {
            this.stack.logWriter.logStackTrace();
        }
        byte[] byArray = sIPMessage.encodeAsBytes();
        long l = System.currentTimeMillis();
        this.sendMessage(byArray, this.peerAddress, this.peerPort, this.peerProtocol, sIPMessage instanceof SIPRequest);
        if (this.stack.serverLog.needsLogging(16)) {
            this.logMessage(sIPMessage, this.peerAddress, this.peerPort, l);
        }
    }

    protected void sendMessage(byte[] byArray, InetAddress inetAddress, int n, boolean bl) throws IOException {
        if (LogWriter.needsLogging) {
            this.stack.logWriter.logStackTrace();
        }
        if (n == -1) {
            if (LogWriter.needsLogging) {
                this.stack.logWriter.logMessage(this.getClass().getName() + ":sendMessage: Dropping reply!");
            }
            throw new IOException("Receiver port not set ");
        }
        if (LogWriter.needsLogging) {
            this.stack.logWriter.logMessage(this.getClass().getName() + ":sendMessage " + inetAddress.getHostAddress() + "/" + n + "\n" + new String(byArray));
            this.stack.logWriter.logMessage("*******************\n");
        }
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
        try {
            DatagramSocket datagramSocket = this.stack.udpFlag ? ((UDPMessageProcessor)this.messageProcessor).sock : new DatagramSocket();
            datagramSocket.send(datagramPacket);
            if (!this.stack.udpFlag) {
                datagramSocket.close();
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            InternalErrorHandler.handleException(exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void sendMessage(byte[] byArray, InetAddress inetAddress, int n, String string, boolean bl) throws IOException {
        if (n == -1) {
            if (!LogWriter.needsLogging) throw new IOException("Receiver port not set ");
            this.stack.logWriter.logMessage(this.getClass().getName() + ":sendMessage: Dropping reply!");
            throw new IOException("Receiver port not set ");
        }
        if (LogWriter.needsLogging) {
            this.stack.logWriter.logMessage(this.getClass().getName() + ":sendMessage " + inetAddress.getHostAddress() + "/" + n + "\n" + new String(byArray));
            this.stack.logWriter.logMessage("*******************\n");
        }
        if (string.compareToIgnoreCase("UDP") == 0) {
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
            try {
                DatagramSocket datagramSocket = this.stack.udpFlag ? ((UDPMessageProcessor)this.messageProcessor).sock : this.stack.getNetworkLayer().createDatagramSocket();
                datagramSocket.send(datagramPacket);
                if (this.stack.udpFlag) return;
                datagramSocket.close();
                return;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                InternalErrorHandler.handleException(exception);
                return;
            }
        } else {
            Socket socket = this.stack.ioHandler.sendBytes(inetAddress, n, "tcp", byArray, bl);
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(byArray, 0, byArray.length);
            outputStream.flush();
        }
    }

    public SIPMessageStack getSIPStack() {
        return this.stack;
    }

    public String getTransport() {
        return "udp";
    }

    public String getHost() {
        return this.stack.stackAddress;
    }

    public int getPort() {
        return ((UDPMessageProcessor)this.messageProcessor).getPort();
    }

    public String getPeerName() {
        return this.peerAddress.getHostName();
    }

    public String getPeerAddress() {
        return this.peerAddress.getHostAddress();
    }

    protected InetAddress getPeerInetAddress() {
        return this.peerAddress;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            bl = false;
        } else {
            UDPMessageChannel uDPMessageChannel = (UDPMessageChannel)object;
            bl = this.getKey().equals(uDPMessageChannel.getKey());
        }
        return bl;
    }

    public String getKey() {
        return UDPMessageChannel.getKey(this.peerAddress, this.peerPort, "UDP");
    }

    public int getPeerPacketSourcePort() {
        return this.peerPacketSourcePort;
    }

    public InetAddress getPeerPacketSourceAddress() {
        return this.peerPacketSourceAddress;
    }

    public String getViaHost() {
        return this.myAddress;
    }

    public int getViaPort() {
        return this.myPort;
    }

    public boolean isReliable() {
        return false;
    }

    public boolean isSecure() {
        return false;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public String getPeerProtocol() {
        return this.peerProtocol;
    }

    public void close() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

